<?php
defined('_PS_VERSION_') OR die('No Direct Script Access Allowed');

class VC_frontendController extends ModuleAdminController 
{
    protected $_ajax_results;
    protected $_ajax_stripslash;
    protected $_filter_whitespace;
    protected $lushslider_model;
    public static $calledFor = 1;
    public function __construct() 
    {        
        $this->display_header = true;
        $this->display_footer = true;
        $this->content_only   = true;
        $this->toolbar_scroll = false;
        $this->show_toolbar = false;
        
        $this->module = 'jscomposer';       
        parent::__construct();
        $this->_ajax_results['error_on'] = 1;
    }

    public function display()
    {
        if(Tools::getValue('vc_action') == 'vc_inline' && Tools::getValue('id_cms')){
            
            $id_cms = Tools::getValue('id_cms');
            $id_lang = Tools::getValue('id_lang');
            $cmspage = new CMS((int)$id_cms);
            $this->meta_title = $cmspage->meta_title[$id_lang];
            
            $this->initHeader();
            $content = $this->getFrontEditContent();            
            $this->initFooter();
            
            $this->ajax = true;
            $this->content = $content;

            parent::display();
            
        }
        
    }
    
    public function getFrontEditContent()
    {                
        ob_start();
        if(isset(JsComposer::$front_editor_actions['current_screen']) && is_callable(JsComposer::$front_editor_actions['current_screen']))
            call_user_func(JsComposer::$front_editor_actions['current_screen']);
        return ob_get_clean();
    }
    public function initHeader()
    {

        parent::initHeader();

    }
    
    public function initFooter()
    {
        parent::initFooter();

    }
    protected function bindToAjaxRequest($post_method = false)
    {
        if(!$this->isXmlHttpRequest())
            die ('We Only Accept Ajax Request');
        if($post_method)
        {
            if(!isset ($_SERVER['REQUEST_METHOD']) OR 'POST' != $_SERVER['REQUEST_METHOD'])
                die ('Only POST Request Method is allowed');
        }                        
        return TRUE;                 
    }
}

