/**
 * Baked Look Book module
 *
 * @author    Baked Themes
 * @copyright Baked Themes
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

jQuery(function($){
    $('.fontOptions').trigger('change');
});

var handle_font_change = function(that,systemFonts)
{
    var systemFontsArr = systemFonts.split(',');
    var selected_font = $(that).val();
    var identi = $(that).attr('id');
    if(!$('#'+identi+'_link').size())
        $('head').append('<link id="'+identi+'_link" rel="stylesheet" type="text/css" href="" />');
    if($.inArray(selected_font, systemFontsArr)<0)
        $('link#'+identi+'_link').attr({href:'http://fonts.googleapis.com/css?family=' + selected_font.replace(' ', '+')});
    $('#'+identi+'_example').css('font-family',selected_font);

};

$(document).ready(function() {
    $('.slides-holder li').each(function( index, value ) { // add suggestion when there are no points of interest
        var points = $(value).find('.point_label');
        var pointsContainer = $(value).find('.imgWrapper');
        if ($(points).size() == 0) {
            $(pointsContainer).append('<div class="doit"><i>&larr;</i><span>Click to the image to add a point of interest</span></div>');
        }
    });
    $(".imgWrapper").click(function(e){
        var obj = $(this);
        var d = new Date();
		var langId = parseInt($(obj).data('langid'));

        var imgID = $('#input-holder-'+langId).data('idimg');
        var idshop = $('#input-holder-'+langId).data("idshop");
        var idlang = $('#input-holder-'+langId).data("idlang");
        var randID = d.getTime();
        var parentOffset = $(this).offset();
        var relX = parseInt(e.pageX - parentOffset.left-8);
        var relY = parseInt(e.pageY - parentOffset.top-8);
        var pointsNumber = obj.find('.point_label').size();
        obj.find('.doit').remove();
       $.ajax({
            type: 'POST',
            url: coordinatePath,
            data: 'ajax=1&action=add&id_baked_look_book='+imgID+'&idcoord='+randID+'&coordX='+relX+'&coordY='+relY+'&idlang='+idlang+'&idshop='+idshop,
            success: function(result){
				if (result == '0')
					console.log('no data');
				else {
					$('#input-holder-'+langId).find('.imgWrapper').append("<div class='point_label' data-pointid='" + randID + "' style='top:" + relY + "px; left:" + relX + "px;'>" + (pointsNumber + 1) + "</div>")
					obj.closest('.image-holder').find(".coordinates-holder").append("<div class='points' data-pointid='" + randID + "'><div class='manage'><span class='num'>" + (pointsNumber + 1) + "</span><span class='dot'>.</span><label for='product'>Product</label></div><span class='remove-point'>&times;</span><div class='productContainer'><input type='text' data-idlang='"+langId+"' data-pid='" + randID + "' value='' class='product_autocomplete' placeholder='Start to type the name of product' /></div></div>");
              }
			  
			  $('.product_autocomplete').autocomplete(
				modulePath+'ajax_products_list.php', {
					minChars: 3,
					autoFill: true,
					max:20,
					matchContains: true,
					mustMatch:true,
					scroll:false,
					cacheLength:0,
					formatItem: function(item) {
						return item[1] + ' - ' + item[0];
					}
				}).result(function(event, data, formatted) {
					complete = 1;
					if (data == null)
					return false;
					var productId = data[1];
					var productName = data[0];
					var idLang = $(this).data("idlang");
					var idcoord = $(this).data("pid");
					$.ajax({
						type: 'POST',
						url: coordinatePath,
						dataType: 'json',
						data: 'ajax=1&action=addProduct&id_baked_look_book='+imgID+'&idprod='+productId+'&idlang='+idLang+'&idshop='+idshop+'&idcoord='+idcoord,
						success: function(result){
							if (result == '0')
								console.log('no data');
							else {
								
								var product = result;
								$('.coordinates-holder').find("[data-pointid='" + idcoord + "']").find('.prodImg').remove();
								$('.coordinates-holder').find("[data-pointid='" + idcoord + "']").find('.productContainer').append('<img src=' + product.url + ' alt=\'\' class="prodImg" />');
							}
						}
					});
				});
            }
        });
    });
    $(".remove-point").live('click', function(e){ // remove point of interest
        var obj = $(this);
        var langId = $(obj).data('langid');
        var imgID = $('#image-holder-'+langId).data("idimg");
        var idshop = $('#image-holder-'+langId).data("idshop");
        var idlang = $('#image-holder-'+langId).data("idlang");
        var removepointid = obj.parent().data("pointid");
        var removepointnum = obj.parent().find('.num').text();
        obj.closest('.coordinates-holder').find('.points').each(function( index, value ) {
            if (removepointnum < (index+1)) {
                var num = $(this).find('.num').text();
                $(this).find('.num').text(num-1);
            }
        });
        obj.closest('.image-holder').find(".imgWrapper").find(".point_label").each(function( index, value ) {
            if (removepointnum < (index+1)) {
                var num = $(this).text();
                $(this).text(num-1);
            }
        });

        $.ajax({
            type: 'POST',
            url: coordinatePath,
            data: 'ajax=1&action=remove&id_slide='+imgID+'&idcoord='+removepointid+'&idlang='+idlang+'&idshop='+idshop,
            success: function(result){
				if (result == '0')
					console.log('no data');
				else {
					obj.closest('.image-holder').find('[data-pointid="' + removepointid + '"]').remove();
				}
            }
        });
    });

		var imgID = $('.coordinates-holder').closest('.image-holder').data("idimg");
		var idshop = $('.coordinates-holder').closest('.image-holder').data("idshop");

		var complete = 0;
		if (complete == 0)
		{
			$('.product_autocomplete').autocomplete(
				modulePath+'ajax_products_list.php', {
					minChars: 3,
					autoFill: true,
					max:20,
					matchContains: true,
					mustMatch:true,
					scroll:false,
					cacheLength:0,
					formatItem: function(item) {
						return item[1] + ' - ' + item[0];
					}
				}).result(function(event, data, formatted) {
					complete = 1;
					if (data == null)
					return false;
					var productId = data[1];
					var productName = data[0];
					var idLang = $(this).data("idlang");
					var idcoord = $(this).data("pid");
					$.ajax({
						type: 'POST',
						url: coordinatePath,
						data: 'ajax=1&action=addProduct&id_baked_look_book='+imgID+'&idprod='+productId+'&idlang='+idLang+'&idshop='+idshop+'&idcoord='+idcoord,
						success: function(result){
							if (result == '0')
								console.log('no data');
							else {
								var product = JSON.parse(result);
								$('.coordinates-holder').find("[data-pointid='" + idcoord + "']").find('.prodImg').remove();
								$('.coordinates-holder').find("[data-pointid='" + idcoord + "']").find('.productContainer').append('<img src=' + product.url + ' alt=\'\' class="prodImg" />');
							}
						}
					});
				});
		}


    $(".tooltip_type").live('click', function(){ // switcher between "text" and "product"
        if ($(this).attr("val") == "text") {
            $(this).closest('.points').find(".point_text").removeClass('hidden');
            $(this).closest('.points').find('.productContainer').addClass('hidden');
        }
        if ($(this).attr("val") == "product") {
            $(this).closest('.points').find(".productContainer").removeClass('hidden');
            $(this).closest('.points').find('.point_text').addClass('hidden');
        }
    });
});
