<?php
/**
 * Baked Look Book module
 *
 * @author    Baked Themes
 * @copyright Baked Themes
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

class BakedLookBookGroup extends ObjectModel
{
	/** @var integer*/
	public $id;
	/** @var string*/
	public $name;
	/** @var integer */
	public $image;
	/** @var integer */
	public $active;
	
	public $id_shop;
	/**
	 * @see ObjectModel::$definition
	 */
	public static $definition = array(
		'table'		 => 'baked_look_book_group',
		'primary'	 => 'id_baked_look_book_group',
		//'multipleshop' => true,
		'multilang' => true,
		'fields'	 => array(
			'name'	 => array( 'type'		 => self::TYPE_STRING, 'size'		 => 255, 'validate'	 => 'isGenericName', 'lang' => true, 'required'	 => true),
			'image'	 => array( 'type'		 => self::TYPE_STRING, 'size'		 => 255, 'validate'	 => 'isGenericName', 'lang' => true ),
			'active' => array( 'type'		 => self::TYPE_BOOL, 'validate'	 => 'isBool' )
		),
	);

	
	public	function __construct($id_baked_look_book_group = null, $id_lang = null, $id_shop = null, Context $context = null)
	{
		parent::__construct($id_baked_look_book_group, $id_lang, $id_shop);
	}
	
	public function add($autodate = true, $null_values = false)
	{
		$context = Context::getContext();
		$id_shop = $context->shop->id;
		$res = parent::add($autodate, $null_values);
		$res &= Db::getInstance()->execute('
			UPDATE `'._DB_PREFIX_.'baked_look_book_group_lang` 
			SET `id_shop` = '.$id_shop.' 
			WHERE `id_baked_look_book_group` = '.(int)$this->id
		);
		return $res;
	}
	public static function getAll($active = 0)
	{
		//Shop::addTableAssociation('baked_look_book_group', array( 'type' => 'shop' ));
		$context = Context::getContext();
		$id_shop = $context->shop->id;
		return Db::getInstance()->executeS('SELECT blbg.*, blbgl.*
			FROM `'._DB_PREFIX_.'baked_look_book_group` blbg
			LEFT JOIN `'._DB_PREFIX_.'baked_look_book_group_lang` blbgl ON blbgl.`id_baked_look_book_group` = blbg.`id_baked_look_book_group`
			'.Shop::addSqlAssociation('baked_look_book_group', 'blbg').
				' WHERE blbgl.`id_shop`='.$id_shop.
						(($active) ? ' AND blbg.`active`=1' : '').
				' GROUP BY blbgl.`id_baked_look_book_group`'
		);
	}

	public function delete()
	{
		$multi = Db::getInstance()->getValue('
			SELECT count(0)
			FROM `'._DB_PREFIX_.'baked_look_book_group_shop`
			WHERE id_baked_look_book_group='.$this->id
		);
		if ($multi > 1)
		{
			return Db::getInstance()->execute('
    			DELETE
    			FROM `'._DB_PREFIX_.'baked_look_book_group_shop`
    			WHERE id_baked_look_book_group='.$this->id.Shop::addSqlRestrictionOnLang()
			);
		}
		else
		{
			$slides	 = Db::getInstance()->executeS('
    			SELECT id_baked_look_book
    			FROM `'._DB_PREFIX_.'baked_look_book`
    			WHERE id_baked_look_book_group='.$this->id
			);
			$res	 = true;
			foreach ($slides as $v)
			{
				$slide = new BakedLookBookClass($v['id_baked_look_book']);
				if ($slide)
					$res &= $slide->delete();
			}
			$res &= parent::delete();
			return $res;
		}
	}

	public static function categoryHasSlide($identify)
	{
		return Db::getInstance()->getValue('
			SELECT count(0)
			FROM `'._DB_PREFIX_.'baked_look_book_group_shop` blbgs
			'.Shop::addSqlAssociation('baked_look_book_group_shop', 'blbgs').'
			WHERE blbgs.`active`=1 '.( is_array($identify) ? ' and blbgs.`id_category` IN ('.implode(',', $identify).') ' : ' and blbgs.`id_category` = '.(int)$identify )
		);
	}

	public static function getSlideGroup($identify, $type = 1)
	{
		$identify	 = (array)$identify;
		
		return Db::getInstance()->executeS('
			SELECT blbgs.*
			FROM `'._DB_PREFIX_.'baked_look_book` blbgs
			'.Shop::addSqlAssociation('baked_look_book_group_shop', 'blbgs').'
			WHERE blbgs.`active`=1 '.$where.'
            ORDER BY blbgs.`position`');
	}
}