<?php

class SupplierController extends SupplierControllerCore
{

	protected function assignOne()
	{
		$nbProducts		 = $this->supplier->getProducts($this->supplier->id, null, null, null, $this->orderBy, $this->orderWay, true);
		$this->pagination((int)$nbProducts);
		$suply_products	 = $this->supplier->getProducts($this->supplier->id, $this->context->cookie->id_lang, (int)$this->p, (int)$this->n, $this->orderBy, $this->orderWay);

		$image_array = array( );
		for ($i = 0; $i < $nbProducts; $i++)
		{
			if (isset($suply_products[$i]['id_product']))
				$image_array[$suply_products[$i]['id_product']] = Product::getHoverProductsImgs($suply_products[$i]['id_product']);
		}
		$this->context->smarty->assign('bakedimages', (isset($image_array) AND $image_array) ? $image_array : NULL);

		$this->context->smarty->assign(array(
			'nb_products'			 => $nbProducts,
			'products'				 => $suply_products,
			'path'					 => ($this->supplier->active ? Tools::safeOutput($this->supplier->name) : ''),
			'supplier'				 => $this->supplier,
			'comparator_max_item'	 => Configuration::get('PS_COMPARATOR_MAX_ITEM')
		));
	}

}