<?php
/*
* 2007-2012 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2012 PrestaShop SA
*  @version  Release: $Revision: 6844 $
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;
	
class bakedfootersocial extends Module
{
	public function __construct()
	{
		$this->name = 'bakedfootersocial';
		$this->tab = 'front_office_features';
		$this->version = '1.0';
		$this->author  = 'Baked Themes';
		$this->bootstrap = true;

		parent::__construct();

		$this->displayName = $this->l('Baked Footer Social');
		$this->description = $this->l('Add social links to the footer area');
	}
	
	public function install()
	{
		return (parent::install() AND Configuration::updateValue('bsmod_facebook', '') && Configuration::updateValue('bsmod_twitter', '') && Configuration::updateValue('bsmod_rss', '') && Configuration::updateValue('bsmod_youtube', '') && Configuration::updateValue('bsmod_pinterest', '')
		&& Configuration::updateValue('bsmod_google', '')
		&& Configuration::updateValue('bsmod_instagram', '')
		&& Configuration::updateValue('bsmod_tumblr', '')
		
		 && $this->registerHook('displayHeader') && $this->registerHook('displaytopfooter'));
	}
	
	public function uninstall()
	{
		//Delete configuration			
		return (Configuration::deleteByName('bsmod_facebook') AND Configuration::deleteByName('bsmod_twitter') AND Configuration::deleteByName('bsmod_youtube') AND Configuration::deleteByName('bsmod_pinterest') AND Configuration::deleteByName('bsmod_rss') AND Configuration::deleteByName('bsmod_google') AND Configuration::deleteByName('bsmod_instagram') AND Configuration::deleteByName('bsmod_tumblr') AND parent::uninstall());
	}
	
	public function getContent()
	{
		// If we try to update the settings
		$output = '';
		if (isset($_POST['submitModule']))
		{	
			Configuration::updateValue('bsmod_facebook', (($_POST['facebook_url'] != '') ? $_POST['facebook_url']: ''));
			Configuration::updateValue('bsmod_twitter', (($_POST['twitter_url'] != '') ? $_POST['twitter_url']: ''));		
			Configuration::updateValue('bsmod_rss', (($_POST['rss_url'] != '') ? $_POST['rss_url']: ''));		
			Configuration::updateValue('bsmod_youtube', (($_POST['youtube_url'] != '') ? $_POST['youtube_url']: ''));		
			Configuration::updateValue('bsmod_pinterest', (($_POST['pinterest_url'] != '') ? $_POST['pinterest_url']: ''));		
			Configuration::updateValue('bsmod_google', (($_POST['google_url'] != '') ? $_POST['google_url']: ''));		
			Configuration::updateValue('bsmod_instagram', (($_POST['instagram_url'] != '') ? $_POST['instagram_url']: ''));		
			Configuration::updateValue('bsmod_tumblr', (($_POST['tumblr_url'] != '') ? $_POST['tumblr_url']: ''));		
			$output = '<div class="conf confirm">'.$this->l('Configuration updated').'</div>';
		}
		
		return '
		<h2>'.$this->displayName.'</h2>
		'.$output.'
		<form action="'.Tools::htmlentitiesutf8($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset class="width2">				
				<label for="facebook_url">'.$this->l('Facebook URL: ').'</label>
				<input type="text" id="facebook_url" name="facebook_url" value="'.Tools::safeOutput((Configuration::get('bsmod_facebook') != "") ? Configuration::get('bsmod_facebook') : "").'" />
				<div class="clear">&nbsp;</div>		
				<label for="twitter_url">'.$this->l('Twitter URL: ').'</label>
				<input type="text" id="twitter_url" name="twitter_url" value="'.Tools::safeOutput((Configuration::get('bsmod_twitter') != "") ? Configuration::get('bsmod_twitter') : "").'" />
				<div class="clear">&nbsp;</div>
								<label for="youtube_url">'.$this->l('Youtube URL: ').'</label>
				<input type="text" id="youtube_url" name="youtube_url" value="'.Tools::safeOutput((Configuration::get('bsmod_youtube') != "") ? Configuration::get('bsmod_youtube') : "").'" />
				<div class="clear">&nbsp;</div>	
				<label for="pinterest_url">'.$this->l('Pinterest URL: ').'</label>
				<input type="text" id="pinterest_url" name="pinterest_url" value="'.Tools::safeOutput((Configuration::get('bsmod_pinterest') != "") ? Configuration::get('bsmod_pinterest') : "").'" />
				
				
				<div class="clear">&nbsp;</div>	
				<label for="google_url">'.$this->l('google URL: ').'</label>
				<input type="text" id="google_url" name="google_url" value="'.Tools::safeOutput((Configuration::get('bsmod_google') != "") ? Configuration::get('bsmod_google') : "").'" />
				
							<div class="clear">&nbsp;</div>	
				<label for="instagram_url">'.$this->l('instagram URL: ').'</label>
				<input type="text" id="instagram_url" name="instagram_url" value="'.Tools::safeOutput((Configuration::get('bsmod_instagram') != "") ? Configuration::get('bsmod_instagram') : "").'" />
				
				
	
			<div class="clear">&nbsp;</div>	
				<label for="tumblr_url">'.$this->l('tumblr URL: ').'</label>
				<input type="text" id="tumblr_url" name="tumblr_url" value="'.Tools::safeOutput((Configuration::get('bsmod_tumblr') != "") ? Configuration::get('bsmod_tumblr') : "").'" />
				
				<div class="clear">&nbsp;</div>	
				<label for="rss_url">'.$this->l('RSS URL: ').'</label>
				<input type="text" id="rss_url" name="rss_url" value="'.Tools::safeOutput((Configuration::get('bsmod_rss') != "") ? Configuration::get('bsmod_rss') : "").'" />
				<div class="clear">&nbsp;</div>						
				<br /><center><input type="submit" name="submitModule" value="'.$this->l('Update settings').'" class="button" /></center>
			</fieldset>
		</form>';
	}
	
	public function hookDisplayHeader()
	{
		$this->context->controller->addCSS(($this->_path).'bakedfootersocial.css', 'all');
		$this->context->controller->addJS(($this->_path).'bakedfootersocial.js');
	}
	
	
		public function hookDisplayLeftColumn()
	{
		return $this->hookDisplaytopfooter();
	}
	
		
	public function hookDisplaytopfooter()
	{
		global $smarty;
	


		$smarty->assign(array(
			'facebook_url' => Configuration::get('bsmod_facebook'),
			'twitter_url' => Configuration::get('bsmod_twitter'),
			'youtube_url' => Configuration::get('bsmod_youtube'),
			'pinterest_url' => Configuration::get('bsmod_pinterest'),
			'google_url' => Configuration::get('bsmod_google'),
			'instagram_url' => Configuration::get('bsmod_instagram'),
			'tumblr_url' => Configuration::get('bsmod_tumblr'),
			'rss_url' => Configuration::get('bsmod_rss')
		));
		return $this->display(__FILE__, 'bakedfootersocial.tpl');
	}
}
?>
