/**
 * 2007-2016 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2016 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 *
 * Don't forget to prefix your containers with your own identifier
 * to avoid any conflicts with others containers.
 */

$(document).ready(function(){

    iqitpopup.script = (function() {

        var $el = $('#iqitpopup');
        var $overlay = $('#iqitpopup-overlay');
        var elHeight = $el.outerHeight();
        var elWidth = $el.outerWidth();
        var $wrapper = $( window );
        var offset = -30;

        var sizeData = {
            size: {
                width: $wrapper.width() + offset,
                height: $wrapper.height() + offset
            }
        };

        function init() {

            $el.addClass('showed-iqitpopup');
            $overlay .addClass('showed-iqitpopupo');

            $el.find('.iqit-btn-newsletter').first().click(function() {
                setCookie();
                $overlay.removeClass('showed-iqitpopupo');
                $el.removeClass('showed-iqitpopup');
            });

            $(document).on('click', '#iqitpopup .cross, #iqitpopup-overlay', function () {
                $overlay.removeClass('showed-iqitpopupo');
                $el.removeClass('showed-iqitpopup');

                if ($("#iqitpopup-checkbox").is(':checked')) {
                    setCookie();
                }
            });
            doResize(sizeData, false);

            $wrapper.resize(function() {
                sizeData.size.width = $wrapper.width() + offset ;
                sizeData.size.height = $wrapper.height() + offset ;
                doResize(sizeData, true);

            });
        }

        function doResize(ui, resize) {
            if (elWidth >= ui.size.width  || elHeight >= ui.size.height) {
                var scale;
                scale = Math.min(
                    ui.size.width / elWidth,
                    ui.size.height / elHeight
                );
                $el.css({
                    transform: "translate(-50%, -50%) scale(" + scale + ")"
                });
            }
            else{
                if (resize){
                    $el.css({
                        transform: "translate(-50%, -50%) scale(1)"
                    });
                }
            }
        }

        function setCookie() {
            var name = iqitpopup.name;
            var value = '1';
            var expire = new Date();
            expire.setDate(expire.getDate() + iqitpopup.time);
            document.cookie = name + "=" + escape(value) + ";path=/;" + ((expire == null) ? "" : ("; expires=" + expire.toGMTString()))
        }

        return { init : init};

    })();

    iqitpopup.script.init();

});








