<?php

if (!defined('_PS_VERSION_'))
    exit;

if (!defined('WPB_VC_VERSION'))
    define('WPB_VC_VERSION', '4.3.4');
if (!defined('WPB_JQUERY_UI_VERSION'))
    define('WPB_JQUERY_UI_VERSION', 'less');
require_once (dirname(__FILE__) . '/classes/VcImageType.php');
require_once (dirname(__FILE__) . '/classes/vccontentanywhere.php');
require_once (dirname(__FILE__) . '/classes/vcproducttabcreator.php');
class JsComposer extends Module{
    public $composer_settings, $post_custom_css = array(), $custom_user_templates_dir = false, $front_js = array(), $front_css = array();
    protected $default_templates = false;
    public static $_url, $instance, $shortcode_tags = array(), $static_shortcode_tags = array(), $sds_current_hook, $sds_action_hooks = array(), $vc_before_init = array();
    public static $front_content_scripts = array(), $backOfficeCalledFor = 0, $VCBackofficeShortcodesAction = array();
    public static $VC_MEDIA = 'vc_media';
    public $vccawobj;
    public $vctcbj;
    public static $vc_image_allowed_attr = 'image|images|img|button_bg_img|icon_img|spacer_img|thumb_img|banner_image|info_img|btn_img|bg_image_new|video_poster|swatch_trans_bg_img|layer_image';
    public $controls = array(
        'add_element',
        'templates',
        'save_backend',
        'preview',
        'frontend',
        'custom_css'
    );
    public static $registeredCSS = array(), $registeredJS = array(),  $front_editor_actions = array();
    public $ajaxController, $image_sizes = array(), $image_sizes_dropdown = array();
    public $mode = 'admin_page';
    public $factory = array();
    public $brand_url = 'http://vc.wpbakery.com/?utm_campaign=VCplugin_header&utm_source=vc_user&utm_medium=backend_editor';
    public $css_class = 'vc_navbar';
    public $controls_filter_name = 'vc_nav_controls';
    public $vc_row_layouts = array(
        array('cells' => '11', 'mask' => '12', 'title' => '1/1', 'icon_class' => 'l_11'),
        array('cells' => '12_12', 'mask' => '26', 'title' => '1/2 + 1/2', 'icon_class' => 'l_12_12'),
        array('cells' => '23_13', 'mask' => '29', 'title' => '2/3 + 1/3', 'icon_class' => 'l_23_13'),
        array('cells' => '13_13_13', 'mask' => '312', 'title' => '1/3 + 1/3 + 1/3', 'icon_class' => 'l_13_13_13'),
        array('cells' => '14_14_14_14', 'mask' => '420', 'title' => '1/4 + 1/4 + 1/4 + 1/4', 'icon_class' => 'l_14_14_14_14'),
        array('cells' => '14_34', 'mask' => '212', 'title' => '1/4 + 3/4', 'icon_class' => 'l_14_34'),
        array('cells' => '14_12_14', 'mask' => '313', 'title' => '1/4 + 1/2 + 1/4', 'icon_class' => 'l_14_12_14'),
        array('cells' => '56_16', 'mask' => '218', 'title' => '5/6 + 1/6', 'icon_class' => 'l_56_16'),
        array('cells' => '16_16_16_16_16_16', 'mask' => '642', 'title' => '1/6 + 1/6 + 1/6 + 1/6 + 1/6 + 1/6', 'icon_class' => 'l_16_16_16_16_16_16'),
        array('cells' => '16_23_16', 'mask' => '319', 'title' => '1/6 + 4/6 + 1/6', 'icon_class' => 'l_16_46_16'),
        array('cells' => '16_16_16_12', 'mask' => '424', 'title' => '1/6 + 1/6 + 1/6 + 1/2', 'icon_class' => 'l_16_16_16_12')
    );
    public $wpb_js_composer_js_view = array();
    public $wpb_js_composer_automapper = array();
    public $smarty;
    public function __construct()
    {
        $dir = _PS_MODULE_DIR_ . 'jscomposer';
        $this->name = 'jscomposer';
        $this->tab = 'front_office_features';
        $this->version = WPB_VC_VERSION;
        $this->author = 'smartdatasoft';
        $this->need_instance = 0;
        $this->secure_key = Tools::encrypt($this->name);
        parent::__construct();
        $this->smarty = $this->context->smarty;
        self::$instance = $this;
        self::$_url = $this->_path;
        self::$sds_action_hooks['wpb_single_image_src'] =  array(&$this,'wpb_single_image_src');
        self::$sds_action_hooks['wpb_gallery_html'] =  array('Vc_Base','galleryHTML');
        self::$sds_action_hooks['delete_image'] =  array('JsComposer','delete_uploaded_file');
        self::$sds_action_hooks['editpost'] =  array($this,'update_cms_frontend');
        self::$sds_action_hooks['wpb_save_css_values'] =  array($this,'updateCSSValues');
        self::$sds_action_hooks['wpb_get_preview_link'] =  array($this,'getPreviewLink');
        $this->displayName = $this->l('Visual Composer.');
        $this->description = $this->l('Visual Composer - Content builder for Prestashop');
        $this->composer_settings = array(
            'APP_ROOT' => $dir,
            'UPLOADS_DIR' => $dir . '/uploads/',
            'WP_ROOT' => _PS_ROOT_DIR_,
            'APP_DIR' => basename($dir),
            'CONFIG_DIR' => $dir . '/config',
            'ASSETS_DIR' => $dir . '/assets',
            'ASSETS_DIR_NAME' => 'assets',
            'CORE_DIR' => $dir . '/include/classes/core',
            'HELPERS_DIR' => $dir . '/include/helpers',
            'SHORTCODES_DIR' => $dir . '/include/classes/shortcodes',
            'SETTINGS_DIR' => $dir . '/include/classes/settings',
            'TEMPLATES_DIR' => $dir . '/include/templates',
            'EDITORS_DIR' => $dir . '/include/classes/editors',
            'PARAMS_DIR' => $dir . '/include/params',
            'UPDATERS_DIR' => $dir . '/include/classes/updaters',
            'VENDORS_DIR' => $dir . '/include/classes/vendors'
        );
        $this->wpb_js_composer_automapper = array('i18nLocaleVcAutomapper', array(
                'are_you_sure_delete' => $this->l('Are you sure you want to delete this shortcode?'),
                'are_you_sure_delete_param' => $this->l("Are you sure you want to delete the shortcode's param?"),
                'my_shortcodes_category' => $this->l('My shortcodes'),
                'error_shortcode_name_is_required' => $this->l("Shortcode name is required."),
                'error_enter_valid_shortcode_tag' => $this->l("Please enter valid shortcode tag."),
                'error_enter_required_fields' => $this->l("Please enter all required fields for params."),
                'new_shortcode_mapped' => $this->l('New shortcode mapped from string!'),
                'shortcode_updated' => $this->l('Shortcode updated!'),
                'error_content_param_not_manually' => $this->l('Content param can not be added manually, please use checkbox.'),
                'error_param_already_exists' => $this->l('Param %s already exists. Param names must be unique.'),
                'error_wrong_param_name' => $this->l('Please use only letters, numbers and underscore for param name'),
                'error_enter_valid_shortcode' => $this->l('Please enter valid shortcode to parse!')
            ));
        $this->wpb_js_composer_js_view = array('i18nLocale',
            array(
                'add_remove_picture' => $this->l('Add/remove picture'),
                'finish_adding_text' => $this->l('Finish Adding Images'),
                'add_image' => $this->l('Add Image'),
                'add_images' => $this->l('Add Images'),
                'main_button_title' => $this->l('Visual Composer'),
                'main_button_title_backend_editor' => $this->l('BACKEND EDITOR'),
                'main_button_title_frontend_editor' => $this->l('FRONTEND EDITOR'),
                'main_button_title_revert' => $this->l('CLASSIC MODE'),
                'please_enter_templates_name' => $this->l('Please enter template name'),
                'confirm_deleting_template' => $this->l('Confirm deleting "{template_name}" template, press Cancel to leave. This action cannot be undone.'),
                'press_ok_to_delete_section' => $this->l('Press OK to delete section, Cancel to leave'),
                'drag_drop_me_in_column' => $this->l('Drag and drop me in the column'),
                'press_ok_to_delete_tab' => $this->l('Press OK to delete "{tab_name}" tab, Cancel to leave'),
                'slide' => $this->l('Slide'),
                'tab' => $this->l('Tab'),
                'section' => $this->l('Section'),
                'please_enter_new_tab_title' => $this->l('Please enter new tab title'),
                'press_ok_delete_section' => $this->l('Press OK to delete "{tab_name}" section, Cancel to leave'),
                'section_default_title' => $this->l('Section'),
                'please_enter_section_title' => $this->l('Please enter new section title'),
                'error_please_try_again' => $this->l('Error. Please try again.'),
                'if_close_data_lost' => $this->l('If you close this window all shortcode settings will be lost. Close this window?'),
                'header_select_element_type' => $this->l('Select element type'),
                'header_media_gallery' => $this->l('Media gallery'),
                'header_element_settings' => $this->l('Element settings'),
                'add_tab' => $this->l('Add tab'),
                'are_you_sure_convert_to_new_version' => $this->l('Are you sure you want to convert to new version?'),
                'loading' => $this->l('Loading...'),
                'set_image' => $this->l('Set Image'),
                'are_you_sure_reset_css_classes' => $this->l('Are you sure that you want to remove all your data?'),
                'loop_frame_title' => $this->l('Loop settings'),
                'enter_custom_layout' => $this->l('Enter custom layout for your row:'),
                'wrong_cells_layout' => $this->l('Wrong row layout format! Example: 1/2 + 1/2 or span6 + span6.'),
                'row_background_color' => $this->l('Row background color'),
                'row_background_image' => $this->l('Row background image'),
                'column_background_color' => $this->l('Column background color'),
                'column_background_image' => $this->l('Column background image'),
                'guides_on' => $this->l('Guides ON'),
                'guides_off' => $this->l('Guides OFF'),
                'template_save' => $this->l('New template successfully saved!'),
                'template_added' => $this->l('Template added to the page.'),
                'template_is_empty' => $this->l('Nothing to save. Template is empty.'),
                'css_updated' => $this->l('Page settings updated!'),
                'update_all' => $this->l('Update all'),
                'confirm_to_leave' => $this->l('The changes you made will be lost if you navigate away from this page.'),
                'inline_element_saved' => $this->l('%s saved!'),
                'inline_element_deleted' => $this->l('%s deleted!'),
                'inline_element_cloned' => $this->l('%s cloned. <a href="#" class="vc_edit-cloned" data-model-id="%s">Edit now?</a>'),
                'gfonts_loading_google_font_failed' => $this->l('Loading Google Font failed'),
                'gfonts_loading_google_font' => $this->l('Loading Font...'),
                'gfonts_unable_to_load_google_fonts' => $this->l('Unable to load Google Fonts'),
            ));
        
        require_once $this->path('HELPERS_DIR', 'helpers_factory.php');
        require_once $this->path('HELPERS_DIR', 'helpers.php');
        require_once $this->path('CORE_DIR', 'interfaces.php');
        require_once $this->path('CORE_DIR', 'class-wpb-map.php');
        require_once $this->path('HELPERS_DIR', 'helpers_api.php');
        require_once $this->path('HELPERS_DIR', 'filters.php');
        require_once $this->path('PARAMS_DIR', 'params.php');
        require_once $this->path('SHORTCODES_DIR', 'shortcodes.php');
    }
    public function install()
    {
        if(!parent::install() 
                || !$this->registerHook('displayBackOfficeHeader') 
                || !$this->registerHook('displayBackOfficeFooter') 
                || !$this->registerHook('displayBackOfficeTop') 
                || !$this->registerHook('vcBeforeInit') 
                || !$this->registerHook('displayHeader') 
                || !$this->registerHook('displayHome') 
                || !$this->registerHook('displayBanner') 
                || !$this->registerHook('displayFooter')
                || !$this->registerHook('displayTop')
                || !$this->registerHook('displayTopColumn')
                || !$this->registerHook('displayProductTab')
                || !$this->registerHook('displayProductTabContent')
                || !$this->registerHook('displayLeftColumnProduct')
                || !$this->registerHook('displayLeftColumn')
                || !$this->registerHook('displayRightColumnProduct')
                || !$this->registerHook('displayRightColumn')
                || !$this->registerHook('displayProductContent')
                || !$this->registerHook('displaySmartBlogLeft')
                || !$this->registerHook('displaySidearea')
                || !$this->registerHook('displayFooterTop')
                || !$this->registerHook('displaySmartBlogRight')
                || !$this->registerHook('displaynav')
                || !$this->registerHook('displayFooterProduct')
                || !$this->registerHook('displayMaintenance')
                || !$this->registerHook('displayMyAccountBlock')
                || !$this->registerHook('displayMyAccountBlockfooter')
                || !$this->registerHook('actionObjectvccontentanywhereAddAfter')
                || !$this->registerHook('actionObjectvccontentanywhereUpdateAfter')
                || !$this->registerHook('actionObjectvccontentanywhereDeleteAfter')
                || !$this->registerHook('actionObjectvcproducttabcreatorAddAfter')
                || !$this->registerHook('actionObjectvcproducttabcreatorUpdateAfter')
                || !$this->registerHook('actionObjectvcproducttabcreatorDeleteAfter')
                || !$this->registerHook('actionAdminPerformanceControllerAfter')
                || !$this->registerHook('actionvccontentanywhereUpdate')
                || !$this->registerHook('actionvcproducttabcreatorUpdate')
                || !$this->insertTable()
                || !$this->installTpls()
                || !$this->moduleControllerRegistration()
                )
            return false;
        // else
            return true;
    }
    public function uninstall() {
        if(!parent::uninstall() 
            || !$this->dropTable()
            || !$this->UninstallTpls()
            || !$this->moduleControllerUnRegistration()
            || !$this->restorfile()
            )
            return false;
        return true;
    }
    public function installTpls()
    {
        // START TINYMCE EDITOR
        if(file_exists(_PS_ROOT_DIR_."/js/admin/tinymce.inc.js")){
            @copy(_PS_ROOT_DIR_."/js/admin/tinymce.inc.js", dirname(__FILE__)."/assets/js/tinymce/backup/tinymce.inc.js");
            @copy(dirname(__FILE__)."/assets/js/tinymce/tinymce.inc.js",_PS_ROOT_DIR_."/js/admin/tinymce.inc.js");
        }else{
            @copy(_PS_ROOT_DIR_."/js/tinymce.inc.js", dirname(__FILE__)."/assets/js/tinymce/backup/tinymce.inc.js");
            @copy(dirname(__FILE__)."/assets/js/tinymce/tinymce.inc.js",_PS_ROOT_DIR_."/js/tinymce.inc.js");
        }
        // END TINYMCE EDITOR
        $dir = _PS_MODULE_DIR_ . 'jscomposer/override/controllers/admin/templates/';
        $dstdir = _PS_OVERRIDE_DIR_.'controllers/admin/templates/';
        if(!is_dir($dstdir))
            @mkdir($dstdir, 0777);
        if(is_dir($dstdir)){
            $folder = opendir($dir);
            while (false !== ($folders = readdir($folder))) {                
                $fn = $folders;                
                if($fn !== '.' && $fn !== '..'){
                    if(is_dir($dir.$fn)){
                        $folder2 = opendir($dir.$fn);
                        while( ($file = readdir($folder2)) !== false){
                            if($file !== '.' && $file !== '..'){
                                @mkdir($dstdir.$fn, 0777);
                                $dstfile = $dstdir.$fn.'/'.$file;
                                Tools::copy($dir.$fn.'/'.$file, $dstfile);
                            }
                        }
                    }else{
                        $dstfile = $dstdir.$fn;
                        Tools::copy($dir.$fn, $dstfile);
                    }
                }
            }
        }
        return true;
    }
    public function UninstallTpls()
    {
        $dirs[] = _PS_OVERRIDE_DIR_.'controllers/admin/templates/';

        $files[] = _PS_OVERRIDE_DIR_.'controllers/admin/AdminCmsController.php';
        $files[] = _PS_OVERRIDE_DIR_.'controllers/front/CmsController.php';
        if(is_array($dirs) && !empty($dirs)){
            foreach ($dirs as $dir) {
               Tools::deleteDirectory($dir);
            }
        }
        if(is_array($files) && !empty($files)){
            foreach ($files as $file){
               Tools::deleteFile($file);
            }
        }
        return true;
    }
    public function restorfile()
    {
        // START COPY TINYMCE
        if(file_exists(_PS_ROOT_DIR_."/js/admin/tinymce.inc.js")){
            @unlink(_PS_ROOT_DIR_."/js/admin/tinymce.inc.js");
            @copy(dirname(__FILE__)."/assets/js/tinymce/backup/tinymce.inc.js",_PS_ROOT_DIR_."/js/admin/tinymce.inc.js");
        }else{
            @unlink(_PS_ROOT_DIR_."/js/tinymce.inc.js");
            @copy(dirname(__FILE__)."/assets/js/tinymce/backup/tinymce.inc.js",_PS_ROOT_DIR_."/js/tinymce.inc.js");
        }
        return true;
        // END COPY TINYMCE
    }
    public function insertTable()
    {
        $sql = array();
        require_once(dirname(__FILE__) . '/include/helpers/install_sql.php');
        if(is_array($sql) && !empty($sql))
        foreach ($sql as $sq) :
            if(!Db::getInstance()->Execute($sq))
                return false;
        endforeach;
                return true;
    }
    public function dropTable()
    {
        $sql = array();
        require_once(dirname(__FILE__) . '/include/helpers/uninstall_sql.php');
        if(is_array($sql) && !empty($sql))
        foreach ($sql as $s) :
            if (!Db::getInstance()->Execute($s))
                return false;
        endforeach;
                return true;
    }
    public function moduleControllerRegistration()
    {
                $langs = Language::getLanguages();
                $id_lang = (int)Configuration::get('PS_LANG_DEFAULT');
                $vctabobj = new Tab();
                $vctabobj->class_name = "Adminjscomposer";
                $vctabobj->module = "";
                $vctabobj->id_parent = 0;
                $vctabobj->active = 1;
                foreach($langs as $l){
                        $vctabobj->name[$l['id_lang']] = $this->l('Visual Composer');
                }
                $vctabobj->save();
                $tab_id = $vctabobj->id;
                require_once(dirname(__FILE__) . '/include/helpers/install_tab.php');
                foreach ($tabvalue as $tab):
                    $newtab = new Tab();
                    $newtab->class_name = $tab['class_name'];
                    if($tab['id_parent'] == 'parent'){
                        $newtab->id_parent = $tab_id;
                    }else{
                        $newtab->id_parent = $tab['id_parent'];
                    }
                    $newtab->active = $tab['active'];
                    $newtab->module = $tab['module'];
                    foreach($langs as $l) {
                        $newtab->name[$l['id_lang']] = $this->l($tab['name']);
                    }
                    $newtab->save();
                endforeach;
                return true;
    }
    public function getcontent()
    {
        $url = Context::getContext()->link->getAdminLink('AdminJsComposerSetting');
        Tools::redirectAdmin($url);
    }
    public function l($str, $mod = ''){
        return htmlspecialchars_decode(parent::l($str));
    }
    public function moduleControllerUnRegistration()
    {
       require_once(dirname(__FILE__) . '/include/helpers/install_tab.php');
        foreach ($tabvalue as $tab):
            $tabid = Tab::getIdFromClassName($tab['class_name']);
            if($tabid){
                $tab = new Tab($tabid);
                $tab->delete();
            }
        endforeach;
        $tabmid = Tab::getIdFromClassName("Adminjscomposer");
        if($tabmid){
            $tabm = new Tab($tabmid);
            $tabm->delete();
        }
        return true;
    }
    private function addCSS($url)
    {
        if(is_array($url)){
            if(!empty($url))
            foreach ($url as $urlcss) {
                echo '<link href="'.$urlcss.'" rel="stylesheet" type="text/css" media="all" />' . "\r\n";
            }
        }else{
        echo '<link href="'.$url.'" rel="stylesheet" type="text/css" media="all" />' . "\r\n";
        }
    }
    private function addJS($url)
    {
        if(is_array($url)){
            if(!empty($url))
            foreach ($url as $urljs){
               echo '<script type="text/javascript" src="' . $urljs . '"></script>' . "\r\n";
            }
        }else{
               echo '<script type="text/javascript" src="' . $url . '"></script>' . "\r\n";
        }
    }
    public static function condition()
    {
        return 
        (Tools::getValue('controller') == 'AdminCmsContent' && (Tools::isSubmit('addcms') || Tools::isSubmit('updatecms'))) 
        || (Tools::getValue('controller') == 'VC_frontend' && Tools::getValue('vc_action') == 'vc_inline' && Tools::getValue('id_cms')) 
        || (Tools::getValue('controller') == 'Adminvccontentanywhere' && (Tools::isSubmit('addvccontentanywhere') || Tools::isSubmit('updatevccontentanywhere'))) 
        || (Tools::getValue('controller') == 'Adminvcproducttabcreator' && (Tools::isSubmit('addvcproducttabcreator') || Tools::isSubmit('updatevcproducttabcreator')));
    }
    public function loadVcFrontendActionScripts()
    {
        $admin_theme = __PS_BASE_URI__.$this->context->controller->admin_webpath.'/themes/'.$this->context->employee->bo_theme.'/css/'.$this->context->employee->bo_css;
        $admin_theme_override = __PS_BASE_URI__.$this->context->controller->admin_webpath.'/themes/'.$this->context->employee->bo_theme.'/css/overrides.css';
        echo "<!-- css files -->\n";
        echo "<style type='text/css'> iframe#vc_inline-frame{border:none;} body.vc_frontend #main .bootstrap, body.vc_frontend > #header, body.vc_frontend > #footer{display:none;} body.vc_frontend #content.nobootstrap, body.vc_frontend > #main{margin:0; padding:0; min-width:0;}</style>\n";
        $this->context->controller->addCSS($admin_theme);
        $this->context->controller->addCSS($admin_theme_override);
//        Media::addJsDef(array(
//            'ad' => __PS_BASE_URI__.$this->context->controller->admin_webpath,
//            'iso' => $this->context->language->iso_code
//        ));
//        echo '<script type="text/javascript">
//            var ad = "'.__PS_BASE_URI__.$this->context->controller->admin_webpath.'";
//            var iso = "'.$this->context->language->iso_code.'";
//        </script>'."\n";
        $this->context->controller->addJS(__PS_BASE_URI__.$this->context->controller->admin_webpath.'/themes/'.$this->context->employee->bo_theme.'/js/vendor/bootstrap.min.js');
        $this->context->controller->addJS(__PS_BASE_URI__.$this->context->controller->admin_webpath.'/themes/'.$this->context->employee->bo_theme.'/js/vendor/modernizr.min.js');
        $this->context->controller->addJS(__PS_BASE_URI__.$this->context->controller->admin_webpath.'/themes/'.$this->context->employee->bo_theme.'/js/modernizr-loads.js');
        $this->context->controller->addJS(__PS_BASE_URI__.$this->context->controller->admin_webpath.'/themes/'.$this->context->employee->bo_theme.'/js/vendor/moment-with-langs.min.js');
        $this->addJS(_PS_JS_DIR_.'tiny_mce/tiny_mce.js');
        $this->addJS(_PS_JS_DIR_.'tinymce.inc.js');
    }
    public function isUpdateCmsPage()
    {
        return Tools::getValue('controller') === 'AdminCmsContent' && Tools::getValue('updatecms') !== FALSE && Tools::getValue('id_cms');
    }
    public function updateCSSValues()
    {
        $post_id = Tools::getValue('post_id');
        $id_lang = Tools::getValue('id_lang');
        $css = Tools::getValue('css');
        $type = Tools::getValue('type');
        $optionname = "_wpb_{$type}_{$post_id}_{$id_lang}_css";        
        Configuration::updateValue($optionname,$css,true);
        die();
    }
    public static function getInstance()
    {
        if (!empty(self::$instance) && self::$instance instanceof JsComposer)
        {
            return self::$instance;
        }
        return self::$instance = new JsComposer();
    }
    public static function VcGetLinkobj()
    {
        $ret = array();
      if(Tools::usingSecureMode())
       $useSSL = true;
      else
       $useSSL = false;
      $protocol_link = (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE')) ? 'https://' : 'http://';
      $protocol_content = (isset($useSSL) AND $useSSL AND Configuration::get('PS_SSL_ENABLED') AND Configuration::get('PS_SSL_ENABLED_EVERYWHERE')) ? 'https://' : 'http://';
      $link = new Link($protocol_link, $protocol_content);
      $ret['protocol_link'] = $protocol_link;
      $ret['protocol_content'] = $protocol_content;
      $ret['obj'] = $link;
      return $ret;
    }
    public static function ModifyImageUrl($img_src = '')
    {
        // /* JsComposer::ModifyImageUrl(); */
        $lnk = self::VcGetLinkobj();
        $img_pathinfo = pathinfo($img_src);
        $mainstr = $img_pathinfo['basename'];
        $static_url = __PS_BASE_URI__.'modules/jscomposer/uploads/'.$mainstr;
        return $lnk['protocol_content'].Tools::getMediaServer($static_url).$static_url;
        // return $img_src;
    }
    public static function remove_shortcode($tag)
    {
        unset(self::$static_shortcode_tags[$tag]);
    }
    public static function add_shortcode($tag, $func)
    {
        self::$static_shortcode_tags[$tag] = $func;
    }
    public static function vc_remove_element($tag)
    {
        vc_remove_element($tag);
    }
    public static function add_shortcode_param( $name, $form_field_callback, $script_url = null )
    {
        $path = _PS_MODULE_DIR_.'jscomposer/include/params/params.php';
        if(file_exists($path)){
            require_once($path);
            return WpbakeryShortcodeParams::addField( $name, $form_field_callback, $script_url );
        }
    }
    public static function do_shortcode($content, $hook_name = '')
    {
        $Vc_Base = new Vc_Base();
        $shortcode_tags = self::$static_shortcode_tags;
        if (empty($shortcode_tags) || !is_array($shortcode_tags))
            return $content;
        $pattern = vc_manager()->get_shortcode_regex();
        self::$sds_current_hook = $hook_name;
        return preg_replace_callback("/$pattern/s", array(__CLASS__, 'do_shortcode_tag'), $content);
    }
    public static function do_shortcode_tag($m)
    {
        $Vc_Base = new Vc_Base();
        $shortcode_tags = self::$static_shortcode_tags;
        if ($m[1] == '[' && $m[6] == ']') {
            return Tools::substr($m[0], 1, -1);
        }
        $tag = $m[2];
        $attr = self::shortcode_parse_atts($m[3]);
        if (isset($m[5]))
        {
            return $m[1] . call_user_func($shortcode_tags[$tag], $attr, $m[5], $tag, self::$sds_current_hook) . $m[6];
        }else{
            return $m[1] . call_user_func($shortcode_tags[$tag], $attr, null, $tag, self::$sds_current_hook) . $m[6];
        }
    }
    public function get_shortcode_regex()
    {
        $shortcode_tags = self::$static_shortcode_tags;
        $tagnames = array_keys($shortcode_tags);
        $tagregexp = join('|', array_map('preg_quote', $tagnames));
        return
                '\\['                              // Opening bracket
                . '(\\[?)'                           // 1: Optional second opening bracket for escaping shortcodes: [[tag]]
                . "($tagregexp)"                     // 2: Shortcode name
                . '(?![\\w-])'                       // Not followed by word character or hyphen
                . '('                                // 3: Unroll the loop: Inside the opening shortcode tag
                . '[^\\]\\/]*'                   // Not a closing bracket or forward slash
                . '(?:'
                . '\\/(?!\\])'               // A forward slash not followed by a closing bracket
                . '[^\\]\\/]*'               // Not a closing bracket or forward slash
                . ')*?'
                . ')'
                . '(?:'
                . '(\\/)'                        // 4: Self closing tag ...
                . '\\]'                          // ... and closing bracket
                . '|'
                . '\\]'                          // Closing bracket
                . '(?:'
                . '('                        // 5: Unroll the loop: Optionally, anything between the opening and closing shortcode tags
                . '[^\\[]*+'             // Not an opening bracket
                . '(?:'
                . '\\[(?!\\/\\2\\])' // An opening bracket not followed by the closing shortcode tag
                . '[^\\[]*+'         // Not an opening bracket
                . ')*+'
                . ')'
                . '\\[\\/\\2\\]'             // Closing shortcode tag
                . ')?'
                . ')'
                . '(\\]?)';                          // 6: Optional second closing brocket for escaping shortcodes: [[tag]]
    }
    public static function shortcode_parse_atts($text)
    {
        $atts = array();
        $pattern = '/(\w+)\s*=\s*"([^"]*)"(?:\s|$)|(\w+)\s*=\s*\'([^\']*)\'(?:\s|$)|(\w+)\s*=\s*([^\s\'"]+)(?:\s|$)|"([^"]*)"(?:\s|$)|(\S+)(?:\s|$)/';
        $text = preg_replace("/[\x{00a0}\x{200b}]+/u", " ", $text);
        if (preg_match_all($pattern, $text, $match, PREG_SET_ORDER)) {
            foreach ($match as $m) {
                if (!empty($m[1]))
                    $atts[strtolower($m[1])] = stripcslashes($m[2]);
                elseif (!empty($m[3]))
                    $atts[strtolower($m[3])] = stripcslashes($m[4]);
                elseif (!empty($m[5]))
                    $atts[strtolower($m[5])] = stripcslashes($m[6]);
                elseif (isset($m[7]) and strlen($m[7]))
                    $atts[] = stripcslashes($m[7]);
                elseif (isset($m[8]))
                    $atts[] = stripcslashes($m[8]);
            }
        }else{
            $atts = ltrim($text);
        }
        return $atts;
    }
    public static function shortcode_atts($pairs, $atts, $shortcode = '')
    {
        $atts = (array) $atts;
        $out = array();
        foreach ($pairs as $name => $default)
        {
            if (array_key_exists($name, $atts))
                $out[$name] = $atts[$name];
            else
                $out[$name] = $default;
        }
        return $out;
    }
    public static function strip_shortcodes($content)
    {
        $shortcode_tags = self::$static_shortcode_tags;
        if (empty($shortcode_tags) || !is_array($shortcode_tags))
            return $content;
        $pattern = vc_manager()->get_shortcode_regex();
        return preg_replace_callback("/$pattern/s", array(__CLASS__, 'strip_shortcode_tag'), $content);
    }
    public static function strip_shortcode_tag($m)
    {
        if ($m[1] == '[' && $m[6] == ']') {
            return Tools::substr($m[0], 1, -1);
        }
        return $m[1] . $m[6];
    }
    public static function wpautop($pee, $br = true) {
        $pre_tags = array();
        if (trim($pee) === '')
            return '';
        $pee = $pee . "\n";
        if (Tools::strpos($pee, '<pre') !== false) {
            $pee_parts = explode('</pre>', $pee);
            $last_pee = array_pop($pee_parts);
            $pee = '';
            $i = 0;
            foreach ($pee_parts as $pee_part) {
                $start = Tools::strpos($pee_part, '<pre');
                if ($start === false) {
                    $pee .= $pee_part;
                    continue;
                }
                $name = "<pre wp-pre-tag-$i></pre>";
                $pre_tags[$name] = Tools::substr($pee_part, $start) . '</pre>';
                $pee .= Tools::substr($pee_part, 0, $start) . $name;
                $i++;
            }
            $pee .= $last_pee;
        }
        $pee = preg_replace('|<br />\s*<br />|', "\n\n", $pee);
        $allblocks = '(?:table|thead|tfoot|caption|col|colgroup|tbody|tr|td|th|div|dl|dd|dt|ul|ol|li|pre|form|map|area|blockquote|address|math|style|p|h[1-6]|hr|fieldset|legend|section|article|aside|hgroup|header|footer|nav|figure|details|menu|summary)';
        $pee = preg_replace('!(<' . $allblocks . '[^>]*>)!', "\n$1", $pee);
        $pee = preg_replace('!(</' . $allblocks . '>)!', "$1\n\n", $pee);
        $pee = str_replace(array("\r\n", "\r"), "\n", $pee); // cross-platform newlines
        if (Tools::strpos($pee, '<option') !== false)
        {
            $pee = preg_replace('|\s*<option|', '<option', $pee);
            $pee = preg_replace('|</option>\s*|', '</option>', $pee);
        }
        if (Tools::strpos($pee, '</object>') !== false) {
            // no P/BR around param and embed
            $pee = preg_replace('|(<object[^>]*>)\s*|', '$1', $pee);
            $pee = preg_replace('|\s*</object>|', '</object>', $pee);
            $pee = preg_replace('%\s*(</?(?:param|embed)[^>]*>)\s*%', '$1', $pee);
        }

        if (Tools::strpos($pee, '<source') !== false || Tools::strpos($pee, '<track') !== false) {
            // no P/BR around source and track
            $pee = preg_replace('%([<\[](?:audio|video)[^>\]]*[>\]])\s*%', '$1', $pee);
            $pee = preg_replace('%\s*([<\[]/(?:audio|video)[>\]])%', '$1', $pee);
            $pee = preg_replace('%\s*(<(?:source|track)[^>]*>)\s*%', '$1', $pee);
        }

        $pee = preg_replace("/\n\n+/", "\n\n", $pee);
        $pees = preg_split('/\n\s*\n/', $pee, -1, PREG_SPLIT_NO_EMPTY);
        $pee = '';
        foreach ($pees as $tinkle) {
            $pee .= '<p>' . trim($tinkle, "\n") . "</p>\n";
        }
        $pee = preg_replace('|<p>\s*</p>|', '', $pee); // under certain strange conditions it could create a P of entirely whitespace
        $pee = preg_replace('!<p>([^<]+)</(div|address|form)>!', "<p>$1</p></$2>", $pee);
        $pee = preg_replace('!<p>\s*(</?' . $allblocks . '[^>]*>)\s*</p>!', "$1", $pee); // don't pee all over a tag
        $pee = preg_replace("|<p>(<li.+?)</p>|", "$1", $pee); // problem with nested lists
        $pee = preg_replace('|<p><blockquote([^>]*)>|i', "<blockquote$1><p>", $pee);
        $pee = str_replace('</blockquote></p>', '</p></blockquote>', $pee);
        $pee = preg_replace('!<p>\s*(</?' . $allblocks . '[^>]*>)!', "$1", $pee);
        $pee = preg_replace('!(</?' . $allblocks . '[^>]*>)\s*</p>!', "$1", $pee);
        if ($br) {
            $pee = preg_replace_callback('/<(script|style).*?<\/\\1>/s', array(__CLASS__, '_autop_newline_preservation_helper'), $pee);
            $pee = preg_replace('|(?<!<br />)\s*\n|', "<br />\n", $pee); // optionally make line breaks
            $pee = str_replace('<WPPreserveNewline />', "\n", $pee);
        }
        $pee = preg_replace('!(</?' . $allblocks . '[^>]*>)\s*<br />!', "$1", $pee);
        $pee = preg_replace('!<br />(\s*</?(?:p|li|div|dl|dd|dt|th|pre|td|ul|ol)[^>]*>)!', '$1', $pee);
        $pee = preg_replace("|\n</p>$|", '</p>', $pee);
        if (!empty($pre_tags))
            $pee = str_replace(array_keys($pre_tags), array_values($pre_tags), $pee);
        return $pee;
    }
    public static function _autop_newline_preservation_helper($matches)
    {
        return str_replace("\n", "<WPPreserveNewline />", $matches[0]);
    }
    public static function shortcode_unautop($pee) {
        $shortcode_tags = self::$static_shortcode_tags;
        if (empty($shortcode_tags) || !is_array($shortcode_tags)) {
            return $pee;
        }
        $tagregexp = join('|', array_map('preg_quote', array_keys($shortcode_tags)));
        $pattern =
                '/'
                . '<p>'                              // Opening paragraph
                . '\\s*+'                            // Optional leading whitespace
                . '('                                // 1: The shortcode
                . '\\['                          // Opening bracket
                . "($tagregexp)"                 // 2: Shortcode name
                . '(?![\\w-])'                   // Not followed by word character or hyphen
                // Unroll the loop: Inside the opening shortcode tag
                . '[^\\]\\/]*'                   // Not a closing bracket or forward slash
                . '(?:'
                . '\\/(?!\\])'               // A forward slash not followed by a closing bracket
                . '[^\\]\\/]*'               // Not a closing bracket or forward slash
                . ')*?'
                . '(?:'
                . '\\/\\]'                   // Self closing tag and closing bracket
                . '|'
                . '\\]'                      // Closing bracket
                . '(?:'                      // Unroll the loop: Optionally, anything between the opening and closing shortcode tags
                . '[^\\[]*+'             // Not an opening bracket
                . '(?:'
                . '\\[(?!\\/\\2\\])' // An opening bracket not followed by the closing shortcode tag
                . '[^\\[]*+'         // Not an opening bracket
                . ')*+'
                . '\\[\\/\\2\\]'         // Closing shortcode tag
                . ')?'
                . ')'
                . ')'
                . '\\s*+'                            // optional trailing whitespace
                . '<\\/p>'                           // closing paragraph
                . '/s';

        return preg_replace($pattern, '$1', $pee);
    }
    public function init()
    {
        $this->vcallmod();
        $this->add_custom_param_code();
        Hook::exec('vcBeforeInit');
        $this->setMode();
        $this->setVersion();
        visual_composer()->init();
        $this->mapper()->init();
        $this->automapper()->map();
        $this->automapper()->addAjaxActions();
        $this->is_admin() && $this->asAdmin();
        vc_enabled_frontend() && vc_frontend_editor()->init();
    }
    public function is_admin()
    {
        if ($this->context->controller->controller_type == 'admin')
            return true;
        return false;
    }
    protected function asAdmin()
    {
        $this->backendEditor()->addHooksSettings();
    }
    public function vc()
    {
        if (!isset($this->factory['vc'])) {
            require_once $this->path('CORE_DIR', 'class-vc-base.php');
            $vc = new Vc_Base();
            require_once $this->path('EDITORS_DIR', 'popups/class-vc-templates-editor.php');
            $vc->setTemplatesEditor(new Vc_Templates_Editor());
            require_once $this->path('EDITORS_DIR', 'popups/class-vc-shortcode-edit-form.php');
            $vc->setEditForm(new Vc_Shortcode_Edit_Form());
            require_once $this->path('VENDORS_DIR', 'class-vc-vendors-manager.php');
            $vc->setVendorsManager(new Vc_Vendors_Manager($this));
            $this->factory['vc'] = $vc;
        }
        return $this->factory['vc'];
    }
    public function vc_loop_include_templates()
    {
        require_once $this->vc_path_dir('TEMPLATES_DIR','params/loop/templates.html');
        
    }
    protected function setMode()
    {     
        if ($this->is_admin())
        {
            if ( $this->vc_action() === 'vc_inline' ) {
                    $this->mode = 'admin_frontend_editor';
            }  else {
                    $this->mode = 'admin_page';
            }
        }elseif( Tools::getValue ('vc_editable') === 'true' )
        {
                    $this->mode = 'page_editable';
        }
    }
    public function mode()
    {
        return $this->mode;
    }
    public static function getAdminUpdateCMSLink($params = array())
    { 
        $link = Context::getContext()->link->getAdminLink('AdminCmsContent');
        if(!empty($params) && is_array($params)){
            $params = http_build_query($params);
            $params = htmlspecialchars_decode($params);
            $link .= "&{$params}";
        }
        return $link;
    }
    public static function getCMSLink($id, $alias = null, $ssl = null, $id_lang = null, $id_shop = null)
    {
        $link = new Link;
        $cms = new CMS($id);
        return $link->getCMSLink($cms, $alias, $ssl, $id_lang, $id_shop);
    }
    protected function setVersion()
    {
        $version = Configuration::get('vc_version');
        if (!is_string($version) || version_compare($version, WPB_VC_VERSION) !== 0) {
            Configuration::updateValue('vc_version', WPB_VC_VERSION);
        }
    }
    public function backendEditor()
    {
        if (!isset($this->factory['backend_editor']))
        {
            require_once $this->path('EDITORS_DIR', 'class-vc-backend-editor.php');
            $this->factory['backend_editor'] = new Vc_Backend_Editor();
        }
        return $this->factory['backend_editor'];
    }
    public function mapper()
    {
        if (!isset($this->factory['mapper'])) {
            require_once $this->path('CORE_DIR', 'class-vc-mapper.php');
            $this->factory['mapper'] = new Vc_Mapper();
        }
        return $this->factory['mapper'];
    }
    public function automapper()
    {
        if (!isset($this->factory['automapper'])) {
            require_once $this->path('SETTINGS_DIR', 'class-vc-automapper.php');
            $this->factory['automapper'] = new Vc_Automapper();
        }
        return $this->factory['automapper'];
    }
    public function updater()
    {
        if (!isset($this->factory['updater'])) {
            require_once $this->path('UPDATERS_DIR', 'class-vc-updater.php');
            $updater = new Vc_Updater();
            require_once $this->vc_path_dir('UPDATERS_DIR', 'class-vc-updating-manager.php');
            $updater->setUpdateManager(new Vc_Updating_Manager(WPB_VC_VERSION, $updater->versionUrl(), vc_plugin_name()));
            $this->factory['updater'] = $updater;
        }
        return $this->factory['updater'];
    }
    public function __get_shortcode_regex() {
        $tagnames = array_keys(self::$shortcode_tags);
        $tagregexp = join('|', array_map('preg_quote', $tagnames));
        return
                '\\['                              // Opening bracket
                . '(\\[?)'                           // 1: Optional second opening bracket for escaping shortcodes: [[tag]]
                . "($tagregexp)"                     // 2: Shortcode name
                . '(?![\\w-])'                       // Not followed by word character or hyphen
                . '('                                // 3: Unroll the loop: Inside the opening shortcode tag
                . '[^\\]\\/]*'                   // Not a closing bracket or forward slash
                . '(?:'
                . '\\/(?!\\])'               // A forward slash not followed by a closing bracket
                . '[^\\]\\/]*'               // Not a closing bracket or forward slash
                . ')*?'
                . ')'
                . '(?:'
                . '(\\/)'                        // 4: Self closing tag ...
                . '\\]'                          // ... and closing bracket
                . '|'
                . '\\]'                          // Closing bracket
                . '(?:'
                . '('                        // 5: Unroll the loop: Optionally, anything between the opening and closing shortcode tags
                . '[^\\[]*+'             // Not an opening bracket
                . '(?:'
                . '\\[(?!\\/\\2\\])' // An opening bracket not followed by the closing shortcode tag
                . '[^\\[]*+'         // Not an opening bracket
                . ')*+'
                . ')'
                . '\\[\\/\\2\\]'             // Closing shortcode tag
                . ')?'
                . ')'
                . '(\\]?)';                          // 6: Optional second closing brocket for escaping shortcodes: [[tag]]
    }
    public function settings() {
        if (!isset($this->factory['settings'])) {
            require_once $this->path('SETTINGS_DIR', 'class-vc-settings.php');
            $this->factory['settings'] = new Vc_Settings();
        }
        return $this->factory['settings'];
    }
    public function vc_action() {
        if ($vc_action = Tools::getValue('vc_action'))
            return $vc_action;
        return null;
    }
    public function vc_post_param($param, $default = null)
    {
        return Tools::getValue($param) ? Tools::getValue($param) : $default;
    }
    public function addDefaultTemplates($data)
    {
        vc_add_default_templates($data);
    }
    public function loadDefaultTemplates()
    {
        return vc_load_default_templates();
    }

    public function path($name, $file = '')
    {
        return $this->vc_path_dir($name, $file);
    }

    public function vc_path_dir($name, $file = '') {

        return $this->composer_settings[$name] . '/' . $file;
    }
    public function vc_include_template($file, $args)
    {
        extract($args);
        require $this->vc_path_dir('TEMPLATES_DIR', $file);
    }
    public function assetUrl($file)
    {
        return ( $this->vc_asset_url($file));
    }
    public function vc_asset_url($url)
    {
        return $this->_path . 'assets/' . $url;
    }
    public function esc_attr_e($string, $textdomain = '')
    {
        echo $this->esc_attr($string);
    }
    public function esc_attr($string)
    {
        return Tools::htmlentitiesUTF8($string);
    }
    public function esc_attr__($string)
    {
        return $this->esc_attr($this->l($string));
    }
    public function lcfirst($str)
    {
        $str[0] = mb_strtolower($str[0]);
        return $str;
    }
    public function vc_studly($value)
    {
        $value = Tools::ucwords(str_replace(array('-', '_'), ' ', $value));
        return str_replace(' ', '', $value);
    }
    public function vc_camel_case($value)
    {
        return $this->lcfirst($this->vc_studly($value));
    }
    public function getControls()
    {
        $list = array();
        foreach ($this->controls as $control) {
            $method = $this->vc_camel_case('get_control_' . $control);
            if (method_exists($this, $method)) {
                $list[] = array($control, $this->$method() . "\n");
            }
        }
        return $list;
    }
    public function renderEditor($post = null)
    {
        $post_id = $page_type = '';
        switch(Tools::getValue('controller')){
            case 'AdminCmsContent':
            case 'VC_frontend':
                $post_id = Tools::getValue('id_cms');
                $page_type = 'cms';
                break;
        }
        $languages = Language::getLanguages();
        foreach($languages as $lang){
            $optname = "_wpb_{$page_type}_{$post_id}_{$lang['id_lang']}_css";
            $this->post_custom_css["{$lang['id_lang']}"] = Configuration::get($optname);
        }
        ob_start();
        $this->vc_include_template('editors/backend_editor.tpl.php', array(
            'editor' => $this,
        ));
        $content = ob_get_clean();
        $content .= $this->renderEditorFooter();
        return $content;
    }
    public function renderEditorFooter()
    {
        ob_start();
        $this->init();
        $this->vc_include_template('editors/partials/backend_editor_footer.tpl.php', array(
            'editor' => $this,
        ));
        return ob_get_clean();
    }
    public function getLogo()
    {
        $output = '<a id="vc_logo" class="vc_navbar-brand" title="' . $this->esc_attr('Visual Composer', 'js_composer')
                . '" href="' . $this->esc_attr($this->brand_url) . '" target="_blank">'
                . $this->l('Visual Composer') . '</a>';
        return $output;
    }
    public function getControlCustomCss()
    {
        return '<li class="vc_pull-right"><a id="vc_post-settings-button" class="vc_icon-btn vc_post-settings" title="'
                . $this->esc_attr('Page settings', 'js_composer') . '">'
                . '<span id="vc_post-css-badge" class="vc_badge vc_badge-custom-css" style="display: none;">' . $this->l('CSS') . '</span></a>'
                . '</li>';
    }
    public function getControlAddElement() {
        return '<li class="vc_show-mobile">'
                . ' <a href="javascript:;" class="vc_icon-btn vc_element-button" data-model-id="vc_element" id="vc_add-new-element" title="'
                . '' . $this->l('Add new element') . '">'
                . ' </a>'
                . '</li>';
    }

    public function getControlTemplates() {
        return '<li><a href="javascript:;" class="vc_icon-btn vc_templates-button vc_navbar-border-right"  id="vc_templates-editor-button" title="'
                . $this->l('Templates') . '"></a></li>';
    }

    public function getControlFrontend()
    {
        if (!function_exists('vc_enabled_frontend'))
            return false;
        return '<li class="vc_pull-right">'
                . '<a href="' . vc_frontend_editor()->getInlineUrl() . '" class="vc_btn vc_btn-primary vc_btn-sm vc_navbar-btn" id="wpb-edit-inline">' . __('Frontend', "js_composer") . '</a>'
                . '</li>';
    }
    public function getControlPreview()
    {
        return '';
    }

    public function getControlSaveBackend()
    {
        return '<li class="vc_pull-right vc_save-backend">'
                . '<a href="javascript:;" class="vc_btn vc_btn-grey vc_btn-sm vc_navbar-btn vc_control-preview">' . $this->l('Preview') . '</a>'
                . '<a class="vc_btn vc_btn-sm vc_navbar-btn vc_btn-primary vc_control-save" id="wpb-save-post">' . $this->l('Update') . '</a>'
                . '</li>';
    }
    public function frontendEditor()
    {
            if ( ! isset( $this->factory['frontend_editor'] ) ) {
                    require_once  $this->path( 'EDITORS_DIR', 'class-vc-frontend-editor.php' );
                    $this->factory['frontend_editor'] = new Vc_Frontend_Editor();
            }
            return $this->factory['frontend_editor'];
    }
    public function setCustomUserShortcodesTemplateDir($dir) {
        preg_replace('/\/$/', '', $dir);
        $this->custom_user_templates_dir = $dir;
    }
    public function getDefaultShortcodesTemplatesDir() {
        return vc_path_dir('TEMPLATES_DIR', 'shortcodes');
    }
    public function getShortcodesTemplateDir($template)
    {
        return '';
    }
    public static function controller_upload_url($link = '')
    {
        $hash = Tools::encrypt(vc_manager()->secure_key);
        $url = Context::getContext()->link->getAdminLink('VC_upload') . '&security_key=' . $hash;
        if ($link != '')
            $url = "{$url}&{$link}";
        return $url;
    }
    public static function delete_uploaded_file()
    {
        $db = Db::getInstance();

        $tablename = _DB_PREFIX_ . self::$VC_MEDIA;

        $imgdir = vc_manager()->composer_settings['UPLOADS_DIR'];

        $data = $_POST;
        
        if(isset($data['img']) && file_exists("{$imgdir}{$data['img']}")){

            $filename = $data['img'];

            $images = array($filename);                        

            $types = VcImageType::getImagesTypes();
            
            foreach($images as $image){
                if(!empty($types)){
                    $filerealname = Tools::substr($image, 0, Tools::strrpos($image, '.'));
                    $ext = substr($image, Tools::strrpos($image, '.'));
                    foreach($types as $imageType){
                        $newfilename = "{$filerealname}-{$imageType['name']}";
                        if (file_exists("{$imgdir}{$newfilename}{$ext}"))
                        {                        
                            Tools::deleteFile("{$imgdir}{$newfilename}{$ext}");
                        }
                    }
                }                
                Tools::deleteFile("{$imgdir}{$image}");
            }
            if($db->query("DELETE FROM {$tablename} WHERE file_name='{$filename}'"))                                

            echo Tools::jsonEncode(array(

                'success'=>'1',

                'output'=>self::get_uploaded_files_markup(self::get_uploaded_files_result())

                ));

            die();

        }

    }
    public static function get_uploaded_files_result()
    {
        $db = Db::getInstance();
        $tablename = _DB_PREFIX_ . self::$VC_MEDIA;
        $db_results = $db->executeS("SELECT * FROM {$tablename}", true, false);
        $results = array();
        if (!empty($db_results)) {
            foreach ($db_results as $dres) {

                $dres = (object) $dres;

                if (isset($dres->file_name) &&
                        !empty($dres->file_name) &&
                        file_exists(vc_manager()->composer_settings['UPLOADS_DIR'] . $dres->file_name)) {

                    $results["{$dres->ID}"] = $dres->file_name;
                }
            }         
        }
        return $results;
    }

    public static function get_uploaded_files_markup($results = array())
    {
        $upload_dir = self::$_url.'uploads/';
        $current_path = vc_manager()->composer_settings['UPLOADS_DIR'];
        ob_start();
        if (!empty($results)):
            ?>
            <div id="divImageList" > <ul id="selectable" class="">
                    <?php
                    $num = 0;

                    foreach ($results as $id => $filename):
                        $filerealname = Tools::substr($filename, 0, Tools::strrpos($filename, '.'));
                        $file_path = $current_path . $filename;
                        $img = $filename;
                        $date = filemtime($file_path);
                        $size = filesize($file_path);
                        // $file_ext = Tools::substr(strrchr($file, '.'), 1);
                        $file_infos = pathinfo($file_path);
                        $file_ext = $file_infos['extension'];
                        // $sorted[$k] = array('file' => $file, 'date' => $date, 'size' => $size, 'extension' => $file_ext);
                        $extension_lower = strtolower($file_ext);

                        $is_img = true;

                        list($img_width, $img_height, $img_type, $attr) = getimagesize($file_path);

                        // if (++$num % 4 === 1):
                        
                        
                        $ext = substr($filename, strrpos($filename, '.'));
                        $thumbimg = "{$filerealname}-vc_media_thumbnail{$ext}";
                        ?>
                        <li data-image="<?php echo $filename ?>" data-id="<?php echo $id?>" class="ff-item-type-2 file">
                            <figure data-type="img" data-name="<?php echo $filename ?>">
                                <a data-function="apply" data-field_id="<?php echo $id?>" href="#" data-file="<?php echo $img ?>" class="link">
                                    <div class="img-precontainer">
                                        <div class="img-container">
                                            <span></span>
                                            <img alt="<?php echo $img ?>" data-id="<?php echo $id?>" src="<?php echo $upload_dir . $thumbimg ?>"  class="original "  >
                                        </div>
                                    </div>
                                    <div class="img-precontainer-mini original-thumb">
                                        <div class="filetype png hide"><?php echo $img_type?></div>
                                        <div class="img-container-mini">
                                            
                                            <img src="<?php echo $upload_dir . $thumbimg ?>" class=" " alt="<?php echo $filerealname ?> thumbnails" />
                                        </div>
                                    </div>
                                </a>

                                <div class="box">
                                    <h4 class="ellipsis">
                                        <a data-function="apply" data-field_id="" data-file-id="<?php echo $id?>" data-file="<?php echo $img ?>" class="link" href="javascript:void('')">
                <?php echo $img ?></a></h4>
                                </div>
                <?php $date = filemtime($current_path . $img); ?>
                                <input type="hidden" class="date" value="<?php echo $date; ?>"/>
                                <input type="hidden" class="size" value="<?php echo $size ?>"/>
                                <input type="hidden" class="extension" value="<?php echo $extension_lower; ?>"/>
                                <input type="hidden" class="name" value="<?php echo $filerealname ?>"/>
                                <input type="hidden" class="id" value="<?php echo $id?>"/>

                                <div class="file-date"><?php echo date(lang_Date_type, $date); ?></div>
                                <div class="file-size"><?php echo $size; ?></div>
                                <div class='img-dimension'><?php
                    if ($is_img) {
                        echo $img_width . "x" . $img_height;
                    }
                    ?></div>
                                <div class='file-extension'><?php echo Tools::safeOutput($extension_lower); ?></div>

                                <figcaption>

                                </figcaption>
                            </figure>
                        </li>
                        <?php
                        
                        

                    endforeach;
                    ?></ul></div><?php
        endif;
        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }
    public function wpb_single_image_src()
    {
        if(Tools::getValue('content') && is_numeric(Tools::getValue('content'))){
            $image_src = $this->_path.'uploads/'.self::get_media_thumbnail_url(Tools::getValue('content'));
            echo JsComposer::ModifyImageUrl($image_src);
            die();
        }
    }
    public static function get_media_thumbnail_url($id = '')
    {
        if(isset($id) && !empty($id)){
            $db = Db::getInstance();
            $tablename = _DB_PREFIX_ . self::$VC_MEDIA;
            $db_results = $db->executeS("SELECT `file_name` FROM {$tablename} WHERE ID={$id}", true, false);
            return isset($db_results[0]['file_name']) ? $db_results[0]['file_name'] : 'no_image.jpg';
        }else{
            return 'no_image.jpg';
        }
    }
    public static function import_media_img($file_url, $folder, $filename)
    {
        $db = Db::getInstance();
        $tablename = _DB_PREFIX_ . self::$VC_MEDIA;
        $db->execute("INSERT INTO {$tablename}(file_name) VALUES('{$filename}')");
        $imgid = $db->Insert_ID();
        if (!empty($imgid) && is_numeric($imgid)) { //new fixing 
            Tools::copy($file_url, $folder . $filename);
            $dir = $folder;            
            $filerealname = Tools::substr($filename, 0, Tools::strrpos($filename, '.'));
            $ext = substr($filename, strrpos($filename, '.'));
            $type = VcImageType::getImagesTypes('active');
            if(!empty($type)){
                foreach($type as $imageType){
                    $newfilename = "{$filerealname}-{$imageType['name']}";
                    if (!file_exists($dir.$newfilename.$ext))
                    {
                        ImageManager::resize($dir.$filename, $dir.$newfilename.$ext, (int)$imageType['width'], (int)$imageType['height']);
                    }

                }
            }
            
            return array("id" => $imgid, "path" => 'uploads/' . $filename);
        }
    }
    public function generateImageSizesArray()
    {
        $sizes = array_merge(array(array('name'=>'default')),VcImageType::getImagesTypes());
        if(!empty($sizes)){
            foreach($sizes as $size){
                if(isset($size['width'])){
                    $this->image_sizes[$size['name']] = "{$size['width']}x{$size['height']}";
                }
                $this->image_sizes_dropdown[$size['name']] = $size['name'];
            }
        }
    }
    public function getImageSize($name)
    {
        if(isset($this->image_sizes[$name]) && !empty($this->image_sizes[$name])) return $this->image_sizes[$name];
        return false;
    }
    public function update_cms_frontend()
    {
        $id_lang = Tools::getValue('id_lang');
        $id_cms = Tools::getValue('post_id');
        $content = Tools::getValue('content');
        if(!empty($id_cms) && !empty($id_lang)){
            $db = Db::getInstance();
            $table = _DB_PREFIX_.'cms_lang';
            
            $content = addcslashes($content, "'");
            
            $content = "<p>{$content}</p>";
            $sql = "UPDATE {$table} SET content='{$content}' WHERE id_cms={$id_cms} AND id_lang={$id_lang}";
            $stat = $db->execute($sql, false);
            var_dump($stat);
        }
    }
    public static function getSmartBlogPostsThumbSizes()
    {
        $dbvc = Db::getInstance();
        $thumb_sizes = $dbvc->executeS("SELECT type_name FROM "._DB_PREFIX_."smart_blog_imagetype WHERE type='post'",true,false);
        $nthumbs = array();
        if(!empty($thumb_sizes)){
            foreach($thumb_sizes as $tsize){           
                $tsize = $tsize['type_name'];           
                $nthumbs["{$tsize}"] = $tsize;
            }
        }
        return $nthumbs;
    }
    public function getPreviewLink()
    {
        $id = Tools::getValue('post_id');
        $id_lang = Tools::getValue('id_lang') ? Tools::getValue('id_lang') : null;
        $id_shop = Tools::getValue('id_shop') ? Tools::getValue('id_shop') : null;
        $type = Tools::getValue('type');
        if($id && $type == 'cms'){
            $ssl = Tools::getValue('ssl') ? Tools::getValue('ssl') : null;            
            echo JsComposer::getCMSLink(intval($id), null, $ssl, $id_lang , $id_shop );
        }
        die();
    }
    public static function getTPLPath($template='',$module_name = 'jscomposer')
    {
        if (Tools::file_exists_cache(_PS_THEME_DIR_.'modules/'.$module_name.'/'.$template))
        return _PS_THEME_DIR_.'modules/'.$module_name.'/'.$template;
        elseif (Tools::file_exists_cache(_PS_THEME_DIR_.'modules/'.$module_name.'/views/templates/front/'.$template))
        return _PS_THEME_DIR_.'modules/'.$module_name.'/views/templates/front/'.$template;
        elseif (Tools::file_exists_cache(_PS_MODULE_DIR_.$module_name.'/views/templates/front/'.$template))
        return _PS_MODULE_DIR_.$module_name.'/views/templates/front/'.$template;
        return false;
    }
    public static function asign_smarty_object()
    {
        $smarty = new smarty();
        JsComposer::fronted_smarty_asign($smarty);
        return $smarty;
    }
    public static function fronted_smarty_asign($smarty)
    {
        // start smarty asign
        smartyRegisterFunction($smarty, 'modifier', 'truncate', 'smarty_modifier_truncate');
        smartyRegisterFunction($smarty, 'modifier', 'secureReferrer', array('Tools', 'secureReferrer'));
        smartyRegisterFunction($smarty, 'function', 't', 'smartyTruncate'); // unused
        smartyRegisterFunction($smarty, 'function', 'm', 'smartyMaxWords'); // unused
        smartyRegisterFunction($smarty, 'function', 'p', 'smartyShowObject'); // Debug only
        smartyRegisterFunction($smarty, 'function', 'd', 'smartyDieObject'); // Debug only
        smartyRegisterFunction($smarty, 'function', 'l', 'smartyTranslate', false);
        smartyRegisterFunction($smarty, 'function', 'hook', 'smartyHook');
        smartyRegisterFunction($smarty, 'function', 'toolsConvertPrice', 'toolsConvertPrice');
        smartyRegisterFunction($smarty, 'modifier', 'json_encode', array('Tools', 'jsonEncode'));
        smartyRegisterFunction($smarty, 'modifier', 'json_decode', array('Tools', 'jsonDecode'));
        smartyRegisterFunction($smarty, 'function', 'dateFormat', array('Tools', 'dateFormat'));
        smartyRegisterFunction($smarty, 'function', 'convertPrice', array('Product', 'convertPrice'));
        smartyRegisterFunction($smarty, 'function', 'convertPriceWithCurrency', array('Product', 'convertPriceWithCurrency'));
        smartyRegisterFunction($smarty, 'function', 'displayWtPrice', array('Product', 'displayWtPrice'));
        smartyRegisterFunction($smarty, 'function', 'displayWtPriceWithCurrency', array('Product', 'displayWtPriceWithCurrency'));
        smartyRegisterFunction($smarty, 'function', 'displayPrice', array('Tools', 'displayPriceSmarty'));
        smartyRegisterFunction($smarty, 'modifier', 'convertAndFormatPrice', array('Product', 'convertAndFormatPrice')); // used twice
        smartyRegisterFunction($smarty, 'function', 'getAdminToken', array('Tools', 'getAdminTokenLiteSmarty'));
        smartyRegisterFunction($smarty, 'function', 'displayAddressDetail', array('AddressFormat', 'generateAddressSmarty'));
        smartyRegisterFunction($smarty, 'function', 'getWidthSize', array('Image', 'getWidth'));
        smartyRegisterFunction($smarty, 'function', 'getHeightSize', array('Image', 'getHeight'));
        smartyRegisterFunction($smarty, 'function', 'addJsDef', array('Media', 'addJsDef'));
        smartyRegisterFunction($smarty, 'block', 'addJsDefL', array('Media', 'addJsDefL'));
        smartyRegisterFunction($smarty, 'modifier', 'boolval', array('Tools', 'boolval'));
        $compared_products = array();
        if (Configuration::get('PS_COMPARATOR_MAX_ITEM') && isset(Context::getcontext()->cookie->id_compare))
        $compared_products = CompareProduct::getCompareProducts(Context::getcontext()->cookie->id_compare);
        if (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE'))
          $link_ssl = true;
        else
          $link_ssl = false;
        $protocol_link = (Configuration::get('PS_SSL_ENABLED') || Tools::usingSecureMode()) ? 'https://' : 'http://';
        $useSSL = ((isset($link_ssl) && $link_ssl && Configuration::get('PS_SSL_ENABLED')) || Tools::usingSecureMode()) ? true : false;
        $protocol_content = ($useSSL) ? 'https://' : 'http://';
        $link = new Link($protocol_link, $protocol_content);
        $currency = Tools::setCurrency(Context::getcontext()->cookie);
            // START cart block
        if ((int)Context::getcontext()->cookie->id_cart)
        {
            $cart = new Cart(Context::getcontext()->cookie->id_cart);
            if ($cart->OrderExists())
            {
                unset($this->context->cookie->id_cart, $cart, Context::getcontext()->cookie->checkedTOS);
                Context::getcontext()->cookie->check_cgv = false;
            }
            /* Delete product of cart, if user can't make an order from his country */
            elseif (intval(Configuration::get('PS_GEOLOCATION_ENABLED')) &&
                    !in_array(strtoupper(Context::getcontext()->cookie->iso_code_country), explode(';', Configuration::get('PS_ALLOWED_COUNTRIES'))) &&
                    $cart->nbProducts() && intval(Configuration::get('PS_GEOLOCATION_NA_BEHAVIOR')) != -1 &&
                    !FrontController::isInWhitelistForGeolocation() &&
                    !in_array($_SERVER['SERVER_NAME'], array('localhost', '127.0.0.1')))
                unset(Context::getcontext()->cookie->id_cart, $cart);
            // update cart values
            elseif (Context::getcontext()->cookie->id_customer != $cart->id_customer || Context::getcontext()->cookie->id_lang != $cart->id_lang || $currency->id != $cart->id_currency)
            {
                if (Context::getcontext()->cookie->id_customer)
                    $cart->id_customer = (int)(Context::getcontext()->cookie->id_customer);
                $cart->id_lang = (int)(Context::getcontext()->cookie->id_lang);
                $cart->id_currency = (int)$currency->id;
                $cart->update();
            }
            /* Select an address if not set */
            if (isset($cart) && (!isset($cart->id_address_delivery) || $cart->id_address_delivery == 0 ||
                !isset($cart->id_address_invoice) || $cart->id_address_invoice == 0) && Context::getcontext()->cookie->id_customer)
            {
                $to_update = false;
                if (!isset($cart->id_address_delivery) || $cart->id_address_delivery == 0)
                {
                    $to_update = true;
                    $cart->id_address_delivery = (int)Address::getFirstCustomerAddressId($cart->id_customer);
                }
                if (!isset($cart->id_address_invoice) || $cart->id_address_invoice == 0)
                {
                    $to_update = true;
                    $cart->id_address_invoice = (int)Address::getFirstCustomerAddressId($cart->id_customer);
                }
                if ($to_update)
                    $cart->update();
            }
        }
        if (!isset($cart) || !$cart->id)
        {
            $cart = new Cart();
            $cart->id_lang = (int)(Context::getcontext()->cookie->id_lang);
            $cart->id_currency = (int)(Context::getcontext()->cookie->id_currency);
            $cart->id_guest = (int)(Context::getcontext()->cookie->id_guest);
            $cart->id_shop_group = (int)Context::getcontext()->shop->id_shop_group;
            $cart->id_shop = Context::getcontext()->shop->id;
            if (Context::getcontext()->cookie->id_customer)
            {
                $cart->id_customer = (int)(Context::getcontext()->cookie->id_customer);
                $cart->id_address_delivery = (int)(Address::getFirstCustomerAddressId($cart->id_customer));
                $cart->id_address_invoice = $cart->id_address_delivery;
            }
            else
            {
                $cart->id_address_delivery = 0;
                $cart->id_address_invoice = 0;
            }

            // Needed if the merchant want to give a free product to every visitors
            Context::getcontext()->cart = $cart;
            CartRule::autoAddToCart(Context::getcontext());
        }
        else
            Context::getcontext()->cart = $cart;
            // END cart block
            $smarty->assign(
              array(
               'page_name' => Context::getcontext()->controller->php_self,
               'add_prod_display' => (int)Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),
               'link' => $link,
               'cart' => $cart,
               'currency' => $currency,
               //'static_token' => Tools::getToken(false),
               'cookie' => Context::getcontext()->cookie,
               'tpl_dir' => _PS_THEME_DIR_,
               'PS_CATALOG_MODE' => Configuration::get('PS_CATALOG_MODE'),
               'PS_STOCK_MANAGEMENT' => Configuration::get('PS_STOCK_MANAGEMENT'),
               'priceDisplay' => Product::getTaxCalculationMethod((int)Context::getcontext()->cookie->id_customer),
               'compared_products' => is_array($compared_products) ? $compared_products : array(),
               'comparator_max_item' => (int)Configuration::get('PS_COMPARATOR_MAX_ITEM')
              )
            );
            // End smarty asign
    }
    public function contenthookvalue($hook = '')
    {
        $context = Context::getContext();
        $page = $context->controller->php_self;
        if(!is_object($this->vccawobj)){
            $this->vccawobj = vccontentanywhere::GetInstance();
        }
        $vcaw = $this->vccawobj;
        $results = $vcaw->GetVcContentAnyWhereByHook($hook);
        if(isset($results) && !empty($results)){
            foreach($results as $result){
                $display_type = $result['display_type'];
                $prd_page = $result['prd_page'];
                $prd_specify = $result['prd_specify'];
                $cat_page = $result['cat_page'];
                $cat_specify = $result['cat_specify'];
                $cms_page = $result['cms_page'];
                $cms_specify = $result['cms_specify'];
                if($result['exception_type'] == 1){
                    $exception_vals = explode(',',$result['exception']);
                    if(in_array($page, $exception_vals)){
                        $allexceptionpage = 'allexcp'.str_replace(' ','',$hook).$page.$result['id_vccontentanywhere'];
                            if($result['content_type'] == 0){
                                $values = $vcaw->ModHookExec($result['modules_list'],$result['module_hook_list']);
                            }else{
                                $values = $vcaw->GetVcContentByAllException($hook,$page);
                            }
                            $this->smarty->assign(array(
                                        'results' => $values
                                    ));
                            return $this->display(__FILE__, 'views/templates/front/jscomposer.tpl',$this->getCacheId(),$allexceptionpage);
                    }
                }else{
                    //start hhhhhhhhhhhhhhhhhh
                    if($result['display_type'] == 1){ //Start display type 1
                        $allpage = 'alpg'.str_replace(' ','',$hook);
                        if(!$this->isCached('jscomposer.tpl',$this->getCacheId(),$allpage))
                        {
                            if($result['content_type'] == 0){
                                $values = $vcaw->ModHookExec($result['modules_list'],$result['module_hook_list']);
                            }else{
                                $values = $vcaw->GetVcContentByAll($hook);
                            }
                        $this->smarty->assign(array(
                                        'results' => $values
                                    ));
                        }
                        return $this->display(__FILE__, 'views/templates/front/jscomposer.tpl',$this->getCacheId(),$allpage);
                    }else{  //Start display type else
                        if($page == 'product'){ //start product page
                            if($result['prd_page'] == 1){
                                $allprdpage = 'alprdpg'.str_replace(' ','',$hook);
                                if(!$this->isCached('jscomposer.tpl', $this->getCacheId(),$allprdpage))
                                {
                                    if($result['content_type'] == 0){
                                        $values = $vcaw->ModHookExec($result['modules_list'],$result['module_hook_list']);
                                    }else{
                                        $values = $vcaw->GetVcContentByAllPRD($hook);
                                    }
                                    $this->smarty->assign(array(
                                                    'results' => $values
                                                ));
                                }
                                return $this->display(__FILE__, 'views/templates/front/jscomposer.tpl', $this->getCacheId(),$allprdpage);
                            }else{
                                $id_product = Tools::getValue('id_product');
                                $id_prd_cats = $vcaw->getProductCategories($id_product);
                                $prd_specify_arr = explode(',',$result['prd_specify']);
                                $prd_specify_prd_arr = array();
                                $prd_specify_cat_arr = array();
                                if(isset($prd_specify_arr) && !empty($prd_specify_arr)){
                                    foreach($prd_specify_arr as $prd_specify_ar){
                                        if(strpos($prd_specify_ar, 'CAT_') !== false){
                                            $id_cat = str_replace('CAT_','',$prd_specify_ar);
                                            if(in_array($id_cat, $id_prd_cats)){
                                                //Start execute and asign
                                                $catprdpage = 'ctprdpg'.str_replace(' ','',$hook).$id_cat;
                                                if(!$this->isCached('jscomposer.tpl',$this->getCacheId(),$catprdpage))
                                                {
                                                    if($result['content_type'] == 0){
                                                        $values = $vcaw->ModHookExec($result['modules_list'],$result['module_hook_list']);
                                                    }else{
                                                        $values = $vcaw->GetVcContentByAllPRDCATID($hook,$id_cat);
                                                    }
                                                    $this->smarty->assign(array(
                                                                    'results' => $values
                                                                ));
                                                }
                                                    return $this->display(__FILE__, 'views/templates/front/jscomposer.tpl',$this->getCacheId(),$catprdpage);
                                                //End execute and asign
                                            }
                                        }elseif(strpos($prd_specify_ar, 'PRD_') !== false){
                                            $id_prd = str_replace('PRD_','',$prd_specify_ar);
                                            if($id_prd == $id_product){
                                                //Start execute and asign 
                                                $spcprdpage = 'spprdpg'.str_replace(' ','',$hook).$id_product;
                                                if(!$this->isCached('jscomposer.tpl',$this->getCacheId(),$spcprdpage))
                                                {
                                                    if($result['content_type'] == 0){
                                                        $values = $vcaw->ModHookExec($result['modules_list'],$result['module_hook_list']);
                                                    }else{
                                                        $values = $vcaw->GetVcContentByAllPRDID($hook,$id_product);
                                                    }
                                                    $this->smarty->assign(array(
                                                                    'results' => $values
                                                                ));
                                                }
                                                return $this->display(__FILE__, 'views/templates/front/jscomposer.tpl',$this->getCacheId(),$spcprdpage);
                                                //End execute and asign    
                                            }
                                        }
                                    }
                                }
                                //exception product page
                            }
                        }//end product page
                        if($page == 'category'){ //start category page
                            if($result['cat_page'] == 1){
                                $allcatpage = 'allcatpage'.str_replace(' ','',$hook);
                                if(!$this->isCached('jscomposer.tpl',$this->getCacheId(),$allcatpage))
                                {
                                    if($result['content_type'] == 0){
                                        $values = $vcaw->ModHookExec($result['modules_list'],$result['module_hook_list']);
                                    }else{
                                        $values = $vcaw->GetVcContentByAllCAT($hook);
                                    }
                                    $this->smarty->assign(array(
                                                    'results' => $values
                                                ));
                                }
                                return $this->display(__FILE__, 'views/templates/front/jscomposer.tpl',$this->getCacheId(),$allcatpage);
                            }else{
                                $id_category = Tools::getValue('id_category');
                                $cat_specify_arr = explode(',',$result['cat_specify']);
                                if(in_array($id_category, $cat_specify_arr)){
                                    $spccatpage = 'cat'.str_replace(' ','',$hook).$id_category;
                                    if(!$this->isCached('jscomposer.tpl',$this->getCacheId(),$spccatpage))
                                    {
                                        if($result['content_type'] == 0){
                                            $values = $vcaw->ModHookExec($result['modules_list'],$result['module_hook_list']);
                                        }else{
                                            $values = $vcaw->GetVcContentByAllCATID($hook,$id_category);
                                        }
                                        $this->smarty->assign(array(
                                                        'results' => $values
                                                    ));
                                    }
                                    return $this->display(__FILE__, 'views/templates/front/jscomposer.tpl',$this->getCacheId(),$spccatpage);
                                }
                                //exception Category page
                            }
                        }//end category page
                        if($page == 'cms'){ //start cms page
                            if($result['cms_page'] == 1){
                                $allcmspage = 'allcmspage'.str_replace(' ','',$hook);
                                if(!$this->isCached('jscomposer.tpl',$this->getCacheId(),$allcmspage))
                                {
                                    if($result['content_type'] == 0){
                                        $values = $vcaw->ModHookExec($result['modules_list'],$result['module_hook_list']);
                                    }else{
                                        $values = $vcaw->GetVcContentByAllCMS($hook);
                                    }
                                    $this->smarty->assign(array(
                                                    'results' => $values
                                                ));
                                }
                                return $this->display(__FILE__,'views/templates/front/jscomposer.tpl',$allcmspage);
                            }else{
                                $id_cms = Tools::getValue('id_cms');
                                $cms_specify_arr = explode(',',$result['cms_specify']);
                                if(in_array($id_cms, $cms_specify_arr)){
                                    $spccmspage = 'cms'.str_replace(' ','',$hook).$id_cms;
                                    if(!$this->isCached('jscomposer.tpl',$this->getCacheId(),$spccmspage ))
                                    {
                                        if($result['content_type'] == 0){
                                            $values = $vcaw->ModHookExec($result['modules_list'],$result['module_hook_list']);
                                        }else{
                                            $values = $vcaw->GetVcContentByAllCMSID($hook,$id_cms);
                                        }
                                        $this->smarty->assign(array(
                                                        'results' => $values
                                                    ));
                                    }
                                    return $this->display(__FILE__, 'views/templates/front/jscomposer.tpl',$this->getCacheId(),$spccmspage );
                                }
                                //exception CMS page
                            }
                        }//end cms page
                    }
                    //end hhhhhhhhhhhhhhhhhh
                } 
            }
        }
    }
    public function vcmaps_init($base = '',$module_name,$vccaw=NULL)
    {
        $hooks = array();

        if(!is_object($this->vccawobj)){
            $this->vccawobj = new vccontentanywhere();
        }
        $vccaw =  $this->vccawobj;
        $mod_name = str_replace('vc_', '',$base);
        if(empty($module_name)){
            $module_name = $mod_name;
        }
        $allhooks = $vccaw->getModuleHookbyedit($mod_name);
        if(isset($allhooks) && !empty($allhooks)){
            foreach($allhooks as $hook)
            {
              $hooks[$hook['name']] = $hook['name'];
            }
        }
        $icon_url = context::getcontext()->shop->getBaseURL().'modules/'.$mod_name.'/logo.png';
        $vc = vc_manager();
        $brands_params = array(
          'name' => $module_name,
          'base' => $base,
          'icon' => $icon_url,
          'category' => 'Modules',
          'params' => array(
            array(
              "type" => "dropdown",
              "heading" => $vc->l("Executed Hook"),
              "param_name" => "execute_hook",
              "value" => $hooks
            ),array(
              "type" => "vc_hidden_field",
              "param_name" => "execute_module",
              "def_value" => $mod_name,
              "value" => $mod_name
            )
          )
        );
        vc_map($brands_params);
    }
    public function GenerateModuleIcon()
    {
        $output = '<style>';
        if(!is_object($this->vccawobj)){
            $this->vccawobj = new vccontentanywhere();
        }
        $vccaw = $this->vccawobj;
        $GetAllmodules_list = $vccaw->GetAllFilterModules();
        foreach($GetAllmodules_list as $value){
            $icon_url = context::getcontext()->shop->getBaseURL().'modules/'.$value['id'].'/logo.png';
            $output .= "
                .vc_el-container #vc_".$value['id']." .vc_element-icon,
                .wpb_vc_".$value['id'] ." .wpb_element_title .vc_element-icon {
                    background-image: url(".$icon_url.");
                    background-image: url(".$icon_url.");
                    -webkit-background-size: contain;
                    -moz-background-size: contain;
                    -ms-background-size: contain;
                    -o-background-size: contain;
                    background-size: contain;
                }
            ";
        }
        $output .= '</style>';
        echo $output;
    }
    public function add_custom_param_code()
    {
        jscomposer::add_shortcode_param('vc_hidden_field',array($this,'vc_hidden_fields_func'));
        jscomposer::add_shortcode_param('vc_product_fileds',array($this,'vc_product_fileds_func'));
        jscomposer::add_shortcode_param('vc_category_fileds',array($this,'vc_category_fileds_func'));
        jscomposer::add_shortcode_param('vc_brands_fileds',array($this,'vc_brands_fileds_func'));
        jscomposer::add_shortcode_param('vc_supplier_fileds',array($this,'vc_supplier_fileds_func'));
    }
    public function vc_hidden_fields_func($settings,$value)
    {
        $outputcontent = '<input type="hidden" name="'.$settings['param_name'].'" value="'.$settings['def_value'].'" class="wpb_vc_param_value wpb-textinput '.$settings['param_name'].' '.$settings['type'].'_field">';
        return $outputcontent;
    }
    public function vc_product_fileds_func($settings,$value)
    {
        $_html = '<div class="'.$settings['param_name'].'">
        <select name="vc_product_fileds_'.$settings['param_name'].'" class=" fixed-width-xl" id="vc_product_fileds_'.$settings['param_name'].'" multiple="true">';
            $allproducts = $this->GetAllProductS();
            foreach($allproducts as  $allprd){
                if(isset($value)){
                    $settings_def_value = explode(",",$value);
                    if(in_array($allprd['id_product'],$settings_def_value)){
                        $selected = 'selected';
                    }else{
                        $selected = '';
                    }
                }else{
                    $selected = '';
                }
                $_html .= '<option '.$selected.' value="'.$allprd['id_product'].'">'.$allprd['name'].'</option>';
            }
        $_html .= '</select>
        <input type="hidden" name="'.$settings['param_name'].'" id="'.$settings['param_name'].'" value="'.$value.'" class="wpb_vc_param_value wpb-textinput '.$settings['param_name'].' '.$settings['type'].'_field">
        <script type="text/javascript">
            $(function(){
                var defVal = $("input#'.$settings['param_name'].'").val();
                if(defVal.length){
                    var ValArr = defVal.split(\',\');
                    for(var n in ValArr){
                        $( "select#vc_product_fileds_'.$settings['param_name'].'" ).children(\'option[value="\'+ValArr[n]+\'"]\').attr(\'selected\',\'selected\');
                    }
                }
                $( "select#vc_product_fileds_'.$settings['param_name'].'" ).select2( { placeholder: "Select Products", width: 200, tokenSeparators: [\',\', \' \'] } ).on(\'change\',function(){
                    var data = $(this).select2(\'data\');
                    var select = $(this);
                    var field = select.next("input#'.$settings['param_name'].'");
                    var saved = \'\';
                    select.children(\'option\').attr(\'selected\',null);
                    if(data.length)
                        $.each(data, function(k,v){
                            var selected = v.id;   
                            select.children(\'option[value="\'+selected+\'"]\').attr(\'selected\',\'selected\');
                            if(k > 0)
                                saved += \',\';
                            saved += selected;                                
                        });
                     field.val(saved);   
                });
            });
        </script>
        </div>';
        return $_html;
    }
    public function vc_brands_fileds_func($settings,$value)
    {
        $_html = '<div class="'.$settings['param_name'].'">
        <select name="vc_brand_fileds_'.$settings['param_name'].'" class=" fixed-width-xl" id="vc_brand_fileds_'.$settings['param_name'].'" multiple="true">';
            $allbrands = $this->GetAllBrandS();
            foreach($allbrands as  $allbrnd){
                if(isset($value)){
                    $settings_def_value = explode(",",$value);
                    if(in_array($allbrnd['id_manufacturer'],$settings_def_value)){
                        $selected = 'selected';
                    }else{
                        $selected = '';
                    }
                }else{
                    $selected = '';
                }
                $_html .= '<option '.$selected.' value="'.$allbrnd['id_manufacturer'].'">'.$allbrnd['name'].'</option>';
            }
        $_html .= '</select>
        <input type="hidden" name="'.$settings['param_name'].'" id="'.$settings['param_name'].'" value="'.$value.'" class="wpb_vc_param_value wpb-textinput '.$settings['param_name'].' '.$settings['type'].'_field">
        <script type="text/javascript">
            $(function(){
                var defVal = $("input#'.$settings['param_name'].'").val();
                if(defVal.length){
                    var ValArr = defVal.split(\',\');
                    for(var n in ValArr){
                        $( "select#vc_brand_fileds_'.$settings['param_name'].'" ).children(\'option[value="\'+ValArr[n]+\'"]\').attr(\'selected\',\'selected\');
                    }
                }
                $( "select#vc_brand_fileds_'.$settings['param_name'].'" ).select2( { placeholder: "Select Brands", width: 200, tokenSeparators: [\',\', \' \'] } ).on(\'change\',function(){
                    var data = $(this).select2(\'data\');
                    var select = $(this);
                    var field = select.next("input#'.$settings['param_name'].'");
                    var saved = \'\';
                    select.children(\'option\').attr(\'selected\',null);
                    if(data.length)
                        $.each(data, function(k,v){
                            var selected = v.id;   
                            select.children(\'option[value="\'+selected+\'"]\').attr(\'selected\',\'selected\');
                            if(k > 0)
                                saved += \',\';
                            saved += selected;                                
                        });
                     field.val(saved);   
                });
            });
        </script>
        </div>';
        return $_html;
    }
    public function vc_category_fileds_func($settings,$value)
    {
        $_html = '<div class="'.$settings['param_name'].'">
        <select name="vc_category_fileds_'.$settings['param_name'].'" class=" fixed-width-xl" id="vc_category_fileds_'.$settings['param_name'].'" multiple="true">';
            $allcategories = $this->GetAllCategorieS();
            foreach($allcategories as  $allprd){
                if(isset($value)){
                    $settings_def_value = explode(",",$value);
                    if(in_array($allprd['id_category'],$settings_def_value)){
                        $selected = 'selected';
                    }else{
                        $selected = '';
                    }
                }else{
                    $selected = '';
                }
                $_html .= '<option '.$selected.' value="'.$allprd['id_category'].'">'.$allprd['name'].'</option>';
            }
        $_html .= '</select>
        <input type="hidden" name="'.$settings['param_name'].'" id="'.$settings['param_name'].'" value="'.$value.'" class="wpb_vc_param_value wpb-textinput '.$settings['param_name'].' '.$settings['type'].'_field">
        <script type="text/javascript">
            $(function(){
                var defVal = $("input#'.$settings['param_name'].'").val();
                if(defVal.length){
                    var ValArr = defVal.split(\',\');
                    for(var n in ValArr){
                        $( "select#vc_category_fileds_'.$settings['param_name'].'" ).children(\'option[value="\'+ValArr[n]+\'"]\').attr(\'selected\',\'selected\');
                    }
                }
                $( "select#vc_category_fileds_'.$settings['param_name'].'" ).select2( { placeholder: "Select Categories", width: 200, tokenSeparators: [\',\', \' \'] } ).on(\'change\',function(){
                    var data = $(this).select2(\'data\');
                    var select = $(this);
                    var field = select.next("input#'.$settings['param_name'].'");
                    var saved = \'\';
                    select.children(\'option\').attr(\'selected\',null);
                    if(data.length)
                        $.each(data, function(k,v){
                            var selected = v.id;   
                            select.children(\'option[value="\'+selected+\'"]\').attr(\'selected\',\'selected\');
                            if(k > 0)
                                saved += \',\';
                            saved += selected;                                
                        });
                     field.val(saved);   
                });
            });
        </script>
        </div>';
        return $_html;
    }
    public function vc_supplier_fileds_func($settings,$value)
    {
        $_html = '<div class="'.$settings['param_name'].'">
        <select name="vc_supplier_fileds_'.$settings['param_name'].'" class=" fixed-width-xl" id="vc_supplier_fileds_'.$settings['param_name'].'" multiple="true">';
            $allsuppliers = $this->GetAllSupplierS();
            foreach($allsuppliers as  $allsplr){
                if(isset($value)){
                    $settings_def_value = explode(",",$value);
                    if(in_array($allsplr['id_supplier'],$settings_def_value)){
                        $selected = 'selected';
                    }else{
                        $selected = '';
                    }
                }else{
                    $selected = '';
                }
                $_html .= '<option '.$selected.' value="'.$allsplr['id_supplier'].'">'.$allsplr['name'].'</option>';
            }
        $_html .= '</select>
        <input type="hidden" name="'.$settings['param_name'].'" id="'.$settings['param_name'].'" value="'.$value.'" class="wpb_vc_param_value wpb-textinput '.$settings['param_name'].' '.$settings['type'].'_field">
        <script type="text/javascript">
            $(function(){
                var defVal = $("input#'.$settings['param_name'].'").val();
                if(defVal.length){
                    var ValArr = defVal.split(\',\');
                    for(var n in ValArr){
                        $( "select#vc_supplier_fileds_'.$settings['param_name'].'" ).children(\'option[value="\'+ValArr[n]+\'"]\').attr(\'selected\',\'selected\');
                    }
                }
                $( "select#vc_supplier_fileds_'.$settings['param_name'].'" ).select2( { placeholder: "Select Supplier", width: 200, tokenSeparators: [\',\', \' \'] } ).on(\'change\',function(){
                    var data = $(this).select2(\'data\');
                    var select = $(this);
                    var field = select.next("input#'.$settings['param_name'].'");
                    var saved = \'\';
                    select.children(\'option\').attr(\'selected\',null);
                    if(data.length)
                        $.each(data, function(k,v){
                            var selected = v.id;   
                            select.children(\'option[value="\'+selected+\'"]\').attr(\'selected\',\'selected\');
                            if(k > 0)
                                saved += \',\';
                            saved += selected;                                
                        });
                     field.val(saved);   
                });
            });
        </script>
        </div>';
        return $_html;
    }
    public function vcallmod()
    {        
        if(!is_object($this->vccawobj)){
            $this->vccawobj = new vccontentanywhere();
        }
        $vccaw = $this->vccawobj;
        $GetAllmodules_list = $vccaw->GetAllFilterModules();
        foreach($GetAllmodules_list as $value){
            JsComposer::add_shortcode('vc_'.$value['id'], array($this,'vcallmodcode'));
            $this->vcmaps_init('vc_'.$value['id'],$value['name'],$vccaw);
        }
    }
    public function vcallmodcode($atts, $content = null)
    {
        extract(JsComposer::shortcode_atts(array(
            'execute_hook' => '',
            'execute_module' => '',
        ),$atts ));
        if(!is_object($this->vccawobj)){
            $this->vccawobj = new vccontentanywhere();
        }
        $vccaw = $this->vccawobj;
        $results = $vccaw->ModHookExec($execute_module,$execute_hook);
        return $results;
    }
    public static function vc_content_filter($content = '')
    {
        $content = JsComposer::do_shortcode($content);
        if((bool)Module::isEnabled('smartshortcode'))
        {
            $smartshortcode = Module::getInstanceByName('smartshortcode');
            $content = $smartshortcode->parse($content);
        }
        return $content;
    }
    public function GetSimpleProductS()
    {
        $context = Context::getContext();
        $id_lang = (int)Context::getContext()->language->id;
        $front = true;
        $sql = 'SELECT p.`id_product`, pl.`name`
                FROM `'._DB_PREFIX_.'product` p
                '.Shop::addSqlAssociation('product', 'p').'
                LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.`id_product` = pl.`id_product` '.Shop::addSqlRestrictionOnLang('pl').')
                WHERE pl.`id_lang` = '.(int)$id_lang.'
                '.($front ? ' AND product_shop.`visibility` IN ("both", "catalog")' : '').'
                ORDER BY pl.`name`';
        return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
    }
    public function GetAllProductS()
    {
        $rs = array();
        $rslt = array();
        $rs =  $this->getSimpleProducts();
        $i = 0;
        foreach($rs as $r){
            $rslt[$i]['id_product'] = $r['id_product'];
            $rslt[$i]['name'] = $r['name'];
            $i++;
        }
        return $rslt;
    }
    public function GetAllBrandS()
    {
        $rs = array();
        $rslt = array();
        $rs =  Manufacturer::getManufacturers();
        $i = 0;
        foreach($rs as $r){
            $rslt[$i]['id_manufacturer'] = $r['id_manufacturer'];
            $rslt[$i]['name'] = $r['name'];
            $i++;
        }
        return $rslt;
    }
    public function GetAllSupplierS()
    {
        $rs = array();
        $rslt = array();
        $rs =  Supplier::getSuppliers();
        $i = 0;
        foreach($rs as $r){
            $rslt[$i]['id_supplier'] = $r['id_supplier'];
            $rslt[$i]['name'] = $r['name'];
            $i++;
        }
        return $rslt;
    }
    public function GetAllCategorieS()
    {
        $rs = array();
        $rslt = array();
        $id_lang = Context::getContext()->language->id;
        $rs =  Category::getCategories($id_lang,true,false);
        $i = 0;
        foreach($rs as $r){
            $rslt[$i]['id_category'] = $r['id_category'];
            $rslt[$i]['name'] = $r['name'];
            $i++;
        }
        return $rslt;
    }
    public function hookvcBeforeInit()
    {
        $this->generateImageSizesArray();
        
        return true;
    }
    public function hookDisplayHeader($params)
    {
        ob_start();
        $this->init();
        $content = ob_get_clean();
        $this->front_css[] = vc_asset_url('css/js_composer.css');
        if(Tools::getValue('vc_editable'))
        {
           $this->front_css[] = vc_asset_url( 'css/js_composer_frontend_editor_iframe.css' );
        } 
        if (!empty($this->front_css))
        {
            foreach ($this->front_css as $css)
            {
                $this->context->controller->addCSS($css);
            }
        }
        $this->front_js[] = array('ui.core', 'effects.core', 'ui.effect', 'ui.widget', 'ui.accordion', 'ui.progressbar', 'ui.tabs','ui.sortable','ui.draggable');
        $this->front_js[] = vc_asset_url('js/js_composer_front.js');
        if (!empty($this->front_js))
        {
            foreach ($this->front_js as $js)
            {
                if (is_string($js) && !preg_match('/^ui\.|^jquery/', $js))
                    $this->context->controller->addJS($js);
                else
                    $this->context->controller->addJqueryUI($js);
            }
        }

        return $content;
    }
    public function hookDisplayBackOfficeHeader()
    {

        Context::getcontext()->controller->addCSS($this->_path . 'assets/css/adminjscomposericon.css');
        if(++self::$backOfficeCalledFor < 3 && Tools::getValue('controller') != 'VC_frontend' && Tools::getValue('controller') != 'Adminvccontentanywhere' && Tools::getValue('controller') != 'Adminvcproducttabcreator')
            return;
        $content = '';
        $this->ajaxController = $this->context->link->getAdminLink('VC_ajax');
        if (self::condition() ) {                    
            $this->init();
            $modulepath = $this->_path . 'assets/';
                        Context::getcontext()->controller->addCSS($modulepath . 'css/select2.css');
            Context::getcontext()->controller->addCSS($modulepath . 'css/select2-bootstrap.css');
            $content = 'var ' . $this->wpb_js_composer_js_view[0] . '=' . Tools::jsonEncode($this->wpb_js_composer_js_view[1]) . ";\n";
            $content .= 'var ' . $this->wpb_js_composer_automapper[0] . '=' . Tools::jsonEncode($this->wpb_js_composer_automapper[1]) . ";\n";
            $content .= 'var vc_ajaxurl="' . $this->ajaxController . "\";\n";
            $content .= 'var wpColorPickerL10n=' . Tools::jsonEncode(array(
                        'clear' => $this->l('Clear'),
                        'defaultString' => $this->l('Default'),
                        'pick' => $this->l('Select Color'),
                        'current' => $this->l('Current Color'))) . ";\n";
            $content .= 'var vc_mediaAjaxUrl = \'' . self::controller_upload_url() . "';\n";
            $content .= "var vc_urlImage = '{$modulepath}';\n";
            $content .= "var id_lang = ".(Tools::getValue('id_lang')? Tools::getValue('id_lang') : $this->context->language->id).";\n";
            if(Tools::getValue('controller') == 'AdminCmsContent'){
                $content .= "var page_id = ".(Tools::getValue('id_cms')? Tools::getValue('id_cms') : "null").";\n";
            }elseif(Tools::getValue('controller') =='Adminvccontentanywhere'){
                $content .= "var page_id = ".(Tools::getValue('id_vccontentanywhere')? Tools::getValue('id_vccontentanywhere') : "null").";\n";
            }elseif(Tools::getValue('controller') == 'Adminvcproducttabcreator'){
                $content .= "var page_id = ".(Tools::getValue('id_vcproducttabcreator')? Tools::getValue('id_vcproducttabcreator') : "null").";\n";
            }else{
                $content .= "var page_id = ".(Tools::getValue('id_cms')? Tools::getValue('id_cms') : "null").";\n";
            }
            switch(Tools::getValue('controller')){
                case 'AdminCmsContent':
                    $content .= "var page_type = 'cms';";
                    break;
                case 'VC_frontend':
                    $content .= "var page_type = 'cms';";
                    break;
                case 'Adminvccontentanywhere':
                    $content .= "var page_type = 'vccaw';";
                    break;
                case 'Adminvcproducttabcreator':
                    $content .= "var page_type = 'vctc';";
                    break;
            }
            if(Tools::getValue('controller') != 'VC_frontend')
                $content .= '$(function(){$("body").addClass("vc_backoffice");});' . "\n";
            $content .= 'var vc_user_mapper =' . Tools::jsonEncode(WPBMap::getUserShortCodes()) . ",\n" .
                    'vc_mapper = ' . Tools::jsonEncode(WPBMap::getShortCodes()) . ",\n" .
                    "vc_mode = '{$this->mode}';\n";
            $frontend_stat = "vc_frontend_enabled = false;\n";
            if((int)Configuration::get('PS_SHOP_ENABLE')) {
                if($this->isUpdateCmsPage()){ 
                    $frontend_stat = "vc_frontend_enabled = true;\n";
                }
            }elseif(in_array(Tools::getRemoteAddr(), explode(',', Configuration::get('PS_MAINTENANCE_IP')))){
                if($this->isUpdateCmsPage()){ 
                    $frontend_stat = "vc_frontend_enabled = true;\n";
                }
            }  
            $content .= $frontend_stat;
            $this->context->controller->addJquery();
            $this->context->controller->addJqueryUI(array('ui.tabs', 'ui.widget', 'ui.sortable', 'ui.droppable', 'ui.draggable', 'ui.accordion', 'ui.autocomplete', 'ui.slider'));
            ob_start();
            if(Tools::getValue('controller') === 'VC_frontend'){
                $this->loadVcFrontendActionScripts();
            }
            $this->addCSS($modulepath . 'lib/bootstrap_modals/css/bootstrap.modals.css');
            $this->addCSS($modulepath . 'css/ui-custom-theme/jquery-ui-less.custom.css');
            $this->addCSS($modulepath . 'css/color-picker.css');
            $this->addCSS($modulepath . 'css/isotope.css');
            // $this->addCSS($modulepath . 'css/animate.css');
            $this->addCSS($modulepath . 'css/js_composer.css');
            $this->addCSS($modulepath . 'css/js_composer_settings.css');
            $this->addCSS($modulepath . 'css/js_composer_backend_editor.css');
            $this->addCSS($modulepath . 'lib/vc_carousel/css/vc_carousel.css');
            $this->addCSS($modulepath . 'css/thickbox.css');
            
            if(isset(self::$VCBackofficeShortcodesAction['admin_init']) 
                    && !empty(self::$VCBackofficeShortcodesAction['admin_init'])){
                
                foreach( self::$VCBackofficeShortcodesAction['admin_init'] as $admin_init)
                    call_user_func($admin_init);
                
            }            
            if (!empty(self::$registeredCSS))
                foreach (self::$registeredCSS as $custom_css)
                    $this->addCSS($custom_css);
                        
            if(isset(self::$VCBackofficeShortcodesAction['admin_head']) 
                    && !empty(self::$VCBackofficeShortcodesAction['admin_head'])){
                
                foreach( self::$VCBackofficeShortcodesAction['admin_head'] as $admin_head)
                    call_user_func($admin_head);
                
            }
            
            
            echo "<script type='text/javascript'>{$content}</script>\n";
            $this->addJS($modulepath . 'lib/isotope/jquery.isotope.min.js');
            $this->addJS($modulepath . 'js/backend/jPaq-1.0.6.min.js');
            $this->addJS($modulepath . 'js/backend/jquery.color.min.js');
            $this->addJS($modulepath . 'js/backend/farbtastic.js');
            $this->addJS($modulepath . 'js/backend/iris.min.js');
            $this->addJS($modulepath . 'js/backend/color-picker.js');
            $this->addJS($modulepath . 'lib/scrollTo/jquery.scrollTo.min.js');
            $this->addJS($modulepath . 'lib/php.default/php.default.min.js');
            $this->addJS($modulepath . 'lib/json-js/json2.js');
            $this->addJS($modulepath . 'js/backend/underscore-min.js');
            $this->addJS($modulepath . 'js/backend/backbone-min.js');
            $this->addJS($modulepath . 'js/backend/shortcode.js');
            $this->addJS($modulepath . 'js/backend/thickbox.js');

            ?>
            <script type="text/javascript">
                function sds_id_lang(){
                    var elem = $('.form-group.translatable-field');
                    var classname = [];
                    var found = window.id_lang;
                    if(elem.length > 0){                        
                        found = window.id_language;
                    }
                    return found;
                }
                function changeFrontEditorLang(){
                    var switch_front = $('a.wpb_switch-to-front-composer');
                    var found = sds_id_lang();
                    if(switch_front.length > 0){
                        var link = switch_front.attr('href');
                        link = link.replace(/id_lang=([0-9]+)/,'id_lang='+found);                        
                        switch_front.attr('href',link);
                        if($('#wpb-edit-inline').length)
                            $('#wpb-edit-inline').attr('href',link);                        
                    }
                }
                $(function(){                    
                    $(document.body).on('focusout','.translatable-field ul.dropdown-menu li a',function(){
                        changeFrontEditorLang();                        
                    });
                });
                
            </script>
            <?php
            if(Tools::getvalue('controller') == 'Adminvccontentanywhere' || Tools::getvalue('controller') == 'Adminvcproducttabcreator'){
                $this->GenerateModuleIcon();
            }
            $content = ob_get_clean();
        }

        return $content;
    }
    public function hookDisplayBackOfficeFooter()
    {
        if (self::condition())
        {
            $modulepath = $this->_path . 'assets/';

            ob_start();
            if(isset(JsComposer::$sds_action_hooks['ps_admin_footer']))
                call_user_func(JsComposer::$sds_action_hooks['ps_admin_footer']);
            
            if (!empty(self::$registeredJS))
                foreach (self::$registeredJS as $custom_js)
                    $this->addJS($custom_js);
            
            $this->addJS('//ajax.googleapis.com/ajax/libs/webfont/1.4.7/webfont.js');
            $this->addJS($modulepath . 'lib/ace-builds/src-min-noconflict/ace.js');
            $this->addJS($modulepath . 'js/backend/composer-tools.js');
            $this->addJS($modulepath . 'js/backend/composer-atts.js');
            $this->addJS($modulepath . 'js/backend/media-editor.js');
            $this->addJS($modulepath . 'lib/autosuggest/jquery.autoSuggest.js');
            $this->addJS($modulepath . 'lib/vc_chart/jquery.vc_chart.js');
            $this->addJS($modulepath . 'js/editors/panels.js');
            $this->addJS($modulepath . 'js/backend/composer-storage.js');
            $this->addJS($modulepath . 'js/backend/composer-models.js');
            $this->addJS($modulepath . 'js/select2.js');
            if(Tools::getValue('controller') !== 'VC_frontend')
            {
                $this->addJS($modulepath . 'js/backend/composer-view.js');
                $this->addJS($modulepath . 'js/backend/composer-custom-views.js');
                $this->addJS($modulepath . 'js/backend/deprecated.js');
            }
            else{
                $this->addJS(vc_asset_url( 'js/frontend_editor/shortcodes_builder.js' ));
                $this->addJS(vc_asset_url( 'js/frontend_editor/models.js' ));
                $this->addJS(vc_asset_url( 'js/frontend_editor/frontend_editor.js' ));
                $this->addJS(vc_asset_url( 'js/frontend_editor/custom_views.js' ));
                $this->addJS(vc_asset_url( 'js/frontend_editor/build.js' ));
            }
            $this->addJS($modulepath . 'lib/vc_carousel/js/transition.js');
            $this->addJS($modulepath . 'lib/vc_carousel/js/vc_carousel.js');
            $this->addJS($modulepath . 'lib/progress-circle/ProgressCircle.js');

            echo '<script type="text/javascript">$(document).ready(function(){
    var content_type_value = $(\'input:radio[name=content_type]:checked\').val();
        if(content_type_value != 1){
            $(".adminvccontentanywhere .composer-switch").hide(0);
        }
});
</script>' . "\r\n";
            return ob_get_clean();
        }
        return '';
    }
    public function hookdisplayBackOfficeTop($params)
    {
        return '<input type="file" name="import_vcc_anywhere" data-url="'.$this->context->link->getAdminLink('Adminvccontentanywhere').'&ajax=1&action=ImportVccontent" id="import_vcc_anywhere" style="display:none;" />';
    }
    public function hookdisplayProductTab($params)
    {
        $compileid = 'vcprdtb';
        if (!$this->isCached('vc_prd_tab_title.tpl', $this->getCacheId(),$compileid))
        {
            $id_product = Tools::getValue('id_product');
            if(!is_object($this->vctcbj)){
                $this->vctcbj = new vcproducttabcreator();
            }
            $vctc = $this->vctcbj;
            if(!is_object($this->vccawobj)){
                $this->vccawobj = vccontentanywhere::GetInstance();
            }
            $vcaw = $this->vccawobj;
            $results = $vctc->GetTabContentByPRDID($id_product,'title');
                      $this->context->smarty->assign(array(
                          'vc_tab_title_results' => $results,
                          'vccontentanywhereobj' => $vcaw,
                          'vc_product_tab_style' => Configuration::get('vc_product_tab_style')
                          ));
        }
            return $this->display(__FILE__, 'views/templates/front/vc_prd_tab_title.tpl', $this->getCacheId(),$compileid);
    }
    public function hookdisplayProductTabContent($params)
    {
        $compileid = 'prdtabcontent';
        if(!$this->isCached('vc_prd_tab_content.tpl',$this->getCacheId(),$compileid))
        {
            $id_product = Tools::getValue('id_product');
            if(!is_object($this->vctcbj)){
                $this->vctcbj = new vcproducttabcreator();
            }
            $vctc = $this->vctcbj;
            if(!is_object($this->vccawobj)){
                $this->vccawobj = vccontentanywhere::GetInstance();
            }
            $vcaw = $this->vccawobj;
            $results = $vctc->GetTabContentByPRDID($id_product,'content');
            $this->context->smarty->assign(array(
                'vccontentanywhereobj' => $vcaw,
                'vc_tab_content_results' => $results,
                'vc_product_tab_style' => Configuration::get('vc_product_tab_style')
                ));
        }
        return $this->display(__FILE__, 'views/templates/front/vc_prd_tab_content.tpl', $this->getCacheId(),$compileid);
    }
    public function hookDisplayFooter($params)
    {
       if(Tools::getValue('vc_editable'))
       {
           $this->context->controller->addJS(vc_asset_url( 'js/js_composer_front.js' ));
           $this->context->controller->addJS(vc_asset_url( 'lib/php.default/php.default.min.js' ));
           $this->context->controller->addJS(vc_asset_url( 'js/frontend_editor/vc_page_editable.js' ));
       }
       $rsts = $this->contenthookvalue('DisplayFooter');
       return $rsts;
    }
    public function hookDisplayLeftColumn()
    {
       $rsts = $this->contenthookvalue('DisplayLeftColumn');
       return $rsts;
    }
    public function hookDisplayBanner()
    {
       $rsts = $this->contenthookvalue('DisplayBanner');
       return $rsts;
    }
    public function hookDisplayTopColumn($params)
    {
       $rsts = $this->contenthookvalue('DisplayTopColumn');
       return $rsts;
    }
    public function hookDisplayTop($params)
    {
       $rsts = $this->contenthookvalue('DisplayTop');
       return $rsts;
    }
    public function hookdisplayHome($params)
    {
       $rsts = $this->contenthookvalue('displayHome');
       return $rsts;
    }
    public function hookdisplayLeftColumnProduct($params)
    {
       $rsts = $this->contenthookvalue('displayLeftColumnProduct');
       return $rsts;
    }
    public function hookdisplayRightColumnProduct($params)
    {
       $rsts = $this->contenthookvalue('displayRightColumnProduct');
       return $rsts;
    }
    public function hookdisplayRightColumn($params)
    {
       $rsts = $this->contenthookvalue('displayRightColumn');
       return $rsts;
    }
    public function hookdisplayProductContent($params)
    {
       $rsts = $this->contenthookvalue('displayProductContent');
       return $rsts;
    }
    public function hookdisplaySmartBlogLeft($params)
    {
       $rsts = $this->contenthookvalue('displaySmartBlogLeft');
       return $rsts;
    }
    public function hookdisplaySmartBlogRight($params)
    {
       $rsts = $this->contenthookvalue('displaySmartBlogRight');
       return $rsts;
    }
    public function hookdisplayFooterTop($params)
    {
       $rsts = $this->contenthookvalue('displayFooterTop');
       return $rsts;
    }
    public function hookdisplaySidearea($params)
    {
       $rsts = $this->contenthookvalue('displaySidearea');
       return $rsts;
    }
    public function hookdisplaynav($params)
    {
       $rsts = $this->contenthookvalue('displaynav');
       return $rsts;
    }
    public function hookdisplayMyAccountBlockfooter($params)
    {
       $rsts = $this->contenthookvalue('displayMyAccountBlockfooter');
       return $rsts;
    }
    public function hookdisplayMyAccountBlock($params)
    {
       $rsts = $this->contenthookvalue('displayMyAccountBlock');
       return $rsts;
    }
    public function hookdisplayMaintenance($params)
    {
       $rsts = $this->contenthookvalue('displayMaintenance');
       return $rsts;
    }
    public function hookdisplayFooterProduct($params)
    {
       $rsts = $this->contenthookvalue('displayFooterProduct');
       return $rsts;
    }
    public function hookactionObjectvccontentanywhereAddAfter($params)
    {
            $this->_clearCache('*');
    }
    public function hookactionObjectvccontentanywhereUpdateAfter($params)
    {
            $this->_clearCache('*');
    }
    public function hookactionObjectvccontentanywhereDeleteAfter($params)
    {
            $this->_clearCache('*');
    }
    public function hookactionObjectvcproducttabcreatorAddAfter($params)
    {
            $this->_clearCache('*');
    }
    public function hookactionObjectvcproducttabcreatorUpdateAfter($params)
    {
            $this->_clearCache('*');
    }
    public function hookactionObjectvcproducttabcreatorDeleteAfter($params)
    {
            $this->_clearCache('*');
    }
    public function hookactionAdminPerformanceControllerAfter($params)
    {
            $this->_clearCache('*');
    }
    public function hookactionvcproducttabcreatorUpdate()
    {
            $this->_clearCache('*');
    }
    public function hookactionvccontentanywhereUpdate()
    {
            $this->_clearCache('*');
    }
    public static function GetLinkobj()
    {
      if(Tools::usingSecureMode())
        $useSSL = true;
      else
        $useSSL = false;

        $protocol_link = (Configuration::get('PS_SSL_ENABLED')) ? 'https://' : 'http://';
        $protocol_content = (isset($useSSL) AND $useSSL AND Configuration::get('PS_SSL_ENABLED')) ? 'https://' : 'http://';
        $link = new Link($protocol_link, $protocol_content);
        return $link;
    }
    // /* Please uncomment this bellow function for using any custom hook */
    // public function __call($function, $args)
    // {
    //     $hook = substr($function,0,4);
    //     if($hook == 'hook'){
    //         $hook_name = substr($function,4);
    //         return $this->contenthookvalue($hook_name);
    //     }else{
    //         return false;
    //     }
    // }
}

