<?php
/**
 * Mercadopago Payments Module for Prestashop
 *
 * @author    Rinku Kazeno <development@kazeno.co>
 *
 * @copyright Copyright (c) 2012-2015, Rinku Kazeno
 * @license   This module is licensed to the user, upon purchase
 *  from either Prestashop Addons or directly from the author,
 *  for use on a single commercial Prestashop install, plus an
 *  optional separate non-commercial install (for development/testing
 *  purposes only). This license is non-assignable and non-transferable.
 *  To use in additional Prestashop installations an additional
 *  license of the module must be purchased for each one.
 *
 *  The user may modify the source of this module to suit their
 *  own business needs, as long as no distribution of either the
 *  original module or the user-modified version is made.
 *
 *  @file-version 1.2
 */

class MercadopagoPaymentModuleFrontController extends ModuleFrontController
{
	public $display_column_left = FALSE;
    public $display_column_right = FALSE;
	public $ssl = TRUE;
    
    public function initContent()
	{
		parent::initContent();
    
        $data = $this->module->process();
        if (in_array(Configuration::get(Mercadopago::CONFIG_PREFIX.'_CHECKOUT_TYPE'), array('modal', 'iframe'))) {
            $this->context->smarty->assign($data);
            $this->setTemplate('confirmation.tpl');
        } else
            Tools::redirect($data['mpInit']);        //send to Mercadopago checkout
    }
}
 
?>