{if Configuration::get('PH_BLOG_DISPLAY_BREADCRUMBS')}
	{capture name=path}
		<a href="{$link->getModuleLink('ph_simpleblog', 'list')}">
			{l s='Blog' mod='ph_simpleblog'}
		</a>
		{if $is_category eq true}
			<span class="navigation-pipe">
				{$navigationPipe}
			</span>
			{$blogCategory->name}
		{/if}
	{/capture}
	{if !$is_16}
		{include file="$tpl_dir./breadcrumb.tpl"}
	{/if}
{/if}

<div class="ph_simpleblog simpleblog-{if $is_category}category{else}home{/if}">
	{if $is_category eq true}
		<div class="baked-head">
		<h1>{$blogCategory->name}</h1>
		<hr class="hr_left">
		</div>
		{if Configuration::get('PH_BLOG_DISPLAY_CATEGORY_IMAGE') && isset($blogCategory->image)}
		<div class="simpleblog-category-image">
			<img src="{$blogCategory->image}" alt="{$blogCategory->name}" class="img-responsive" />
		</div>
		{/if}

		{if !empty($blogCategory->description) && Configuration::get('PH_BLOG_DISPLAY_CAT_DESC')}
		<div class="ph_cat_description">
			{$blogCategory->description}
		</div>
		{/if}
	{else}
		<div class="baked-head">
		<h1>{$blogMainTitle}</h1>
		<hr class="hr_left">
		</div>
	{/if}

	{if isset($posts) && count($posts)}
		<div class="row simpleblog-posts">

			{foreach from=$posts item=post}

				{assign var='cols' value='col-md-6 col-xs-6 col-ms-12'}

				{if $columns eq '3'}
					{assign var='cols' value='col-md-4 col-xs-4 col-ms-12'}
				{/if}

				{if $columns eq '4'}
					{assign var='cols' value='col-md-3 col-xs-3 col-ms-12'}
				{/if}

				{if $columns eq '3'}
				<div class="simpleblog-post-item {if $blogLayout eq 'grid'}col-md-4 col-sm-6 col-xs-12 col-ms-12 {cycle values="first-in-line,second-in-line,last-in-line"}{else}col-md-12{/if}">
				{elseif $columns eq '4'}
				<div class="simpleblog-post-item {if $blogLayout eq 'grid'}col-md-3 col-sm-6 col-xs-12 col-ms-12 {cycle values="first-in-line,second-in-line,third-in-line,last-in-line"}{else}col-md-12{/if}">
				{else}
				<div class="simpleblog-post-item {if $blogLayout eq 'grid'}col-md-6 col-sm-6 col-xs-12 col-ms-12 {cycle values="first-in-line,last-in-line"}{else}col-md-12{/if}">
				{/if}

					<div class="post-item">

						{if isset($post.banner) && Configuration::get('PH_BLOG_DISPLAY_THUMBNAIL')}
							<div class="post-thumbnail">
								<a href="{$post.url|escape:'html':'UTF-8'}" title="{l s='Permalink to' mod='ph_simpleblog'} {$post.title|escape:'html':'UTF-8'}">
									{if $blogLayout eq 'full'}
										<img src="{$post.banner_wide}" alt="{$post.title}" class="img-responsive" />
									{else}
										<img src="{$post.banner_thumb}" alt="{$post.title}" class="img-responsive" />
									{/if}
								</a>
							</div>
						{/if}

						<div class="post-title">
							<h5><a href="{$post.url|escape:'html':'UTF-8'}" title="{l s='Permalink to' mod='ph_simpleblog'} {$post.title}">{$post.title|escape:'html':'UTF-8'}</a></h5>
						</div><!-- .post-title -->

						{if Configuration::get('PH_BLOG_DISPLAY_DESCRIPTION')}
						<div class="post-content">
							{$post.short_content|strip_tags:'UTF-8'}

							{if Configuration::get('PH_BLOG_DISPLAY_MORE')}
							<div class="post-read-more">
								<a href="{$post.url|escape:'html':'UTF-8'}" title="{l s='Read more' mod='ph_simpleblog'}">{l s='Read more' mod='ph_simpleblog'} <i class="fa fa-chevron-right"></i></a>
							</div><!-- .post-read-more -->
							{/if}
						</div>	
						{/if}

						<div class="post-additional-info post-meta-info">
							{if Configuration::get('PH_BLOG_DISPLAY_DATE')}
								<span class="post-date">
									<i class="fa fa-calendar"></i> {$post.date_add|date_format:Configuration::get('PH_BLOG_DATEFORMAT')}
								</span>
							{/if}

							{if $is_category eq false && Configuration::get('PH_BLOG_DISPLAY_CATEGORY')}
								<span class="post-category">
									<i class="fa fa-tags"></i> <a href="{$post.category_url}" title="">{$post.category}</a>
								</span>
							{/if}

							{if isset($post.author) && !empty($post.author) && Configuration::get('PH_BLOG_DISPLAY_AUTHOR')}
								<span class="post-author">
									<i class="fa fa-user"></i> {$post.author}
								</span>
							{/if}
						</div><!-- .post-additional-info post-meta-info -->
					</div><!-- .post-item -->
				</div><!-- .simpleblog-post-item -->

			{/foreach}
		</div><!-- .row -->
		
		{if $is_category}
			{include file="./pagination.tpl" rewrite=$blogCategory->link_rewrite type='category'}
		{else}
			{include file="./pagination.tpl" rewrite=false type=false}
		{/if}
	{else}
		<p class="warning alert alert-warning">{l s='There are no posts' mod='ph_simpleblog'}</p>
	{/if}
</div><!-- .ph_simpleblog -->
<script>
var currentBlog = '{if $is_category}category{else}home{/if}';
$(window).load(function() {
	$('body').addClass('simpleblog simpleblog-'+currentBlog);
});
</script>