<?php
/**
 * Mercadopago Payments Module for Prestashop
 *
 * @author    Rinku Kazeno <development@kazeno.co>
 *
 * @copyright Copyright (c) 2012-2015, Rinku Kazeno
 * @license   This module is licensed to the user, upon purchase
 *  from either Prestashop Addons or directly from the author,
 *  for use on a single commercial Prestashop install, plus an
 *  optional separate non-commercial install (for development/testing
 *  purposes only). This license is non-assignable and non-transferable.
 *  To use in additional Prestashop installations an additional
 *  license of the module must be purchased for each one.
 *
 *  The user may modify the source of this module to suit their
 *  own business needs, as long as no distribution of either the
 *  original module or the user-modified version is made.
 *
 *  @file-version 1.16
 */

class MercadopagoValidationModuleFrontController extends ModuleFrontController
{
    public $display_header = FALSE;
	public $display_footer = FALSE;
    public $display_column_left = FALSE;
    public $display_column_right = FALSE;
	public $ssl = FALSE;

    protected $lock_handler;
    protected $lockActive = FALSE;

    public function initContent()
	{
        self::$initialized = TRUE;
        $this->process();

        if (Tools::getValue('cid') && Tools::getValue('tid')) {       //Customer came back from Mercadopago's page after paying
            $cart = New Cart((int)Tools::getValue('cid'));
            $currency = new Currency($cart->id_currency);
            $shop = new Shop($cart->id_shop);
            $this->context->shop = $shop;
            $this->context->cart = $cart;
            $this->context->currency = $currency;
            $transactionId = pSQL(Tools::getValue('tid'));
            $cart_details = $cart->getSummaryDetails(null, true);
            if (!$this->module->getFieldFromTransactionId($transactionId,'order_id') && $this->lock() && !$cart->OrderExists() && !Order::getOrderByCartId($cart->id)) {
                ob_start();         //Catch 'Cart cannot be loaded or an order has already been placed using this cart' error
                $this->module->validateOrder($cart->id, Configuration::get(Mercadopago::CONFIG_PREFIX.'_WAIT_STATUS'), $cart_details['total_price'], 'Mercadopago', $cart->gift_message, array('transaction_id'=>$transactionId), $cart->id_currency, false, $cart->secure_key);
                ob_end_clean();
                $this->module->assignOrderToTransaction($cart);
                $this->unlock();
            }
            Tools::redirect('index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.Order::getOrderByCartId($cart->id).'&key='.$cart->secure_key);
        } elseif (Tools::getValue('topic') AND Tools::getValue('id') AND Tools::getValue('topic') == 'payment') {     //IPN notification arrived
            $json = $this->module->queryTransactionData(Tools::getValue('id'));
            $transactionId = pSQL($json['external_reference']);
            $orderId = $this->module->getFieldFromTransactionId($transactionId, 'order_id');
            if (!$orderId) {            //Mercadopago IPN order notification came before customer returned to page
                $cartId = $this->module->getFieldFromTransactionId($transactionId, 'cart_id') OR die('Cart not registered');
                $cart = New Cart((int)$cartId);
                $currency = new Currency($cart->id_currency);
                $shop = new Shop($cart->id_shop);
                $this->context->shop = $shop;
                $this->context->cart = $cart;
                $this->context->currency = $currency;
                $cart_details = $cart->getSummaryDetails(null, true);
                if (!$this->module->getFieldFromTransactionId($transactionId,'order_id') && $this->lock() && !$cart->OrderExists() && !Order::getOrderByCartId($cart->id)) {
                    $this->module->validateOrder($cart->id, Configuration::get(Mercadopago::CONFIG_PREFIX.'_WAIT_STATUS'), $cart_details['total_price'], 'Mercadopago', $cart->gift_message, array('transaction_id'=>$transactionId), $cart->id_currency, false, $cart->secure_key);
                    $this->module->assignOrderToTransaction($cart);
                    $this->unlock();
                }
                $orderId = $this->module->getFieldFromTransactionId($transactionId, 'order_id');
            }
            $order = new Order($orderId);
            $fee = $this->module->getFieldFromTransactionId($transactionId, 'fee');
            $orderToPay = $this->module->getTotalWithFee($order->total_paid, $fee);
            $cart = new Cart($order->id_cart);
            $cart_details = $cart->getSummaryDetails(null, true);
            $cartToPay = $this->module->getTotalWithFee($cart_details['total_price'], $fee);
            switch ($json['status']) {
                case 'in_mediation':
                case 'pending':
                case 'in_process':
                case 'rejected':
                    $varname = 'status_'.$json['status'];
                    if (isset(MpOverride::$$varname) && is_int(MpOverride::$$varname))
                        $order->setCurrentState(MpOverride::$$varname);
                    break;
                case 'approved':
                    if (in_array($order->getCurrentState(), $this->editableStatuses())) {        //Don't change status if it was changed manually before
                        if (abs($json['transaction_amount'] - $orderToPay) > $this->module->delta) { //The payed amount doesn't match
                            if ((abs($json['transaction_amount'] - $cartToPay) < $this->module->delta) && (isset(MpOverride::$status_order_cart_discrepancy) && is_int(MpOverride::$status_order_cart_discrepancy))) {
                                $order->setCurrentState(MpOverride::$status_order_cart_discrepancy);
                            } elseif (isset(MpOverride::$status_payment_discrepancy) && is_int(MpOverride::$status_payment_discrepancy))
                                $order->setCurrentState(MpOverride::$status_payment_discrepancy);
                            else
                                $order->setCurrentState(Configuration::get('PS_OS_ERROR'));
                        } else {       //All is well
                            if (in_array($order->getCurrentState(), array((int)Configuration::get('PS_OS_OUTOFSTOCK_UNPAID'))) && !(isset(MpOverride::$force_outofstock_unpaid_status_update) && MpOverride::$force_outofstock_unpaid_status_update))
                                $order->setCurrentState(Configuration::get('PS_OS_OUTOFSTOCK_PAID'));
                            else
                                $order->setCurrentState(Configuration::get('PS_OS_PAYMENT'));
                        }
                    }
                    break;
                case 'cancelled':
                    $order->setCurrentState(Configuration::get('PS_OS_CANCELED'));
                    break;

                case 'refunded':
                    if (in_array($order->getCurrentState(), $this->editableStatuses()))
                        $order->setCurrentState(Configuration::get('PS_OS_REFUND'));
                    break;
                default:
                    //$status = 'Unrecognized status';
                    break;
            }
            echo '';    //Force 200 OK header send
        }
    }

    public function editableStatuses()
    {
        $statuses = array((int)Configuration::get(Mercadopago::CONFIG_PREFIX.'_WAIT_STATUS'), (int)Configuration::get('PS_OS_OUTOFSTOCK_UNPAID'));
        if (isset(MpOverride::$editableStatuses) && is_array(MpOverride::$editableStatuses)) {
            foreach (MpOverride::$editableStatuses as $status) {
                if (is_int($status))
                    $statuses[] = $status;
            }
        }
        return $statuses;
    }

    /**
     *  Lock validator.lock file while we validate the order
     */
    protected function lock()
    {
        $this->lock_handler = fopen(_PS_MODULE_DIR_.Mercadopago::MODULE_NAME.'/'.Mercadopago::LOCK_FILE, 'w+');
        if(!flock($this->lock_handler, LOCK_EX)) {
            return FALSE;
        }
        $this->lockActive = TRUE;
        ftruncate($this->lock_handler, 0);
        fwrite($this->lock_handler, 'Locked at '.date(DATE_RFC2822)." \n");
        fflush($this->lock_handler);
        return TRUE;
    }

    /**
     *  Unlock validator.lock file after validating the order
     */
    protected function unlock()
    {
        if(!flock($this->lock_handler, LOCK_UN)) {
            return FALSE;
        }
        ftruncate($this->lock_handler, 0);
        $this->lockActive = FALSE;
        return TRUE;
    }

    /**
     *  redirect to store on 'Cart cannot be loaded or an order has already been placed using this cart' error
     */
    public function __destruct()
    {
        if ($this->lockActive) {
            $this->unlock();
        }
        $message = ob_get_clean();
        if (strpos($message, 'rder has already been placed') > 0) {
            Tools::redirect('index.php?controller=order-confirmation');
        }
    }
}

?>