<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class Customizationprices extends Module
{
    public $output = '';
    
    public function __construct()
    {
        $this->name = 'customizationprices';
        $this->tab = 'pricing_promotion';
        $this->version = '1.3.0';
        $this->author = 'Jose Aguilar';
        $this->bootstrap = true;
        $this->module_key = "3f161f3821036070cc7c629b28326ccc";

        parent::__construct();

        $this->displayName = $this->l('Customization Prices');
        $this->description = $this->l('Add a price to customizable products.');
        
        include_once dirname(__FILE__).'/classes/CustomizationFieldPrice.php';
    }
        
    public function createTables() {

        Db::getInstance()->Execute('
        CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'customization_field_price` (
        `id_customization_field_price` int( 10 ) NOT NULL AUTO_INCREMENT ,
        `name` varchar( 20 ) NOT NULL ,
        `field_name` varchar( 20 ) NOT NULL ,
        `price` decimal(10,2) NOT NULL,
        PRIMARY KEY (`id_customization_field_price`)
        ) ENGINE = InnoDB DEFAULT CHARSET=utf8;');

        CustomizationFieldPrice::addCustomFieldPrices($this->context->language->id);

        return true;
    }

    public function deleteTables() {
        Db::getInstance()->Execute('DROP TABLE `'._DB_PREFIX_.'customization_field_price`');
        return true;
    }
	
    public function install()
    {	
        if (!parent::install() || 
                !$this->createTables() || 
                !$this->registerHook('displayRightColumnProduct') || 
                !$this->registerHook('displayHeader'))
                return false;
        return true;
    }

    public function uninstall()
    {		
        if(!parent::uninstall() || !$this->deleteTables())
                return false;
        return true;
    }
	
    public function getContent()
    {
        CustomizationFieldPrice::addCustomFieldPrices($this->context->language->id);
        
        if (Tools::isSubmit('submitCustomizationPrices')) {

            $error = false;
            $errors = '';

            foreach (Tools::getValue('fields') as $key => $value) {
                //echo $key.' '.$value.'<br/>';
                if (!$key OR $key < 0 OR !Validate::isFloat((float)$key)) {
                    $errors .= $this->l('Invalid number of ').$key.'<br/>';
                    $error = true;
                }
                else {
                    //echo $key.' '.$value.'<br/>'; die();
                    CustomizationFieldPrice::setCustomFieldPrice($key, $value);
                }      
            }

            if ($error != false) {
                $this->output .= $this->displayError($errors);
            }
            else {
                $this->output .= $this->displayConfirmation($this->l('The prices was successfully edited.'));
            }
        }

        $this->output .= $this->displayForm();
        
        return $this->output;
    }
    
    public function displayForm() {
        
        $fields = array();

        $languages = Language::getLanguages(false);
        foreach ($languages as $k => $language)
            $languages[$k]['is_default'] = (int)$language['id_lang'] == Configuration::get('PS_LANG_DEFAULT');

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = 'customizationprices';
        $helper->identifier = $this->identifier;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->languages = $languages;
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
        $helper->allow_employee_form_lang = false;
        $helper->toolbar_scroll = false;
        //$helper->toolbar_btn = $this->initToolbar();
        $helper->title = $this->l('Settings');
        $helper->submit_action = 'submitCustomizationPrices';

        $this->fields_form[0]['form'] = array(
            'tinymce' => false,
            'legend' => array(
                'title' => $this->l('Settings'),
                'image' => $this->_path.'logo.gif'
            ),
            'submit' => array(
                'name' => 'submitCustomizationPrices',
                'title' => $this->l('Save'),
                'class' => 'button pull-right'
            ),   
        );
        
        $customization_field_prices = CustomizationFieldPrice::getCustomFieldPrices();
        //d($customization_field_prices);
        if ($customization_field_prices) {	
            foreach ($customization_field_prices as $row) {	
                $fields[] = array(
                    'type' => 'text',
                    'label' => $row['name'],
                    'name' => 'fields['.$row['field_name'].']',
                    'lang' => false,
                    'col' => 3,
                    'required' => false,
                ); 
            }
        }
        else {
            $this->output .= $this->displayError($this->l('There is not customization fields.'));
        }
        
        $this->fields_form[0]['form']['input'] = $fields;

        foreach ($customization_field_prices as $row) {           
            $helper->fields_value['fields['.$row['field_name'].']'] = $row['price'];
        }

        return $helper->generateForm($this->fields_form);
    }

    public function hookDisplayRightColumnProduct($params) {

        $id_product = Tools::getValue('id_product');
        $product = new Product($id_product, $this->context->language->id, $this->context->shop->id);

        CustomizationFieldPrice::addCustomFieldPrices($this->context->language->id);

        if ($product->customizable == 1) {
            $this->context->smarty->assign(array(
                'custom_fields_product' => CustomizationFieldPrice::getCustomFieldbyProduct($id_product, $this->context->language->id)
            ));
            return $this->display(__FILE__, 'customizationprices-product.tpl');
        }
    }

    public function hookDisplayFooterProduct($params) {
        return $this->hookDisplayRightColumnProduct($params);
    }

    public function hookDisplayHeader() {
        $this->context->controller->addCSS($this->_path.'views/css/customizationprices.css', 'all');
    } 
}