<?php

include_once dirname(__FILE__).'/lib/TwitterOAuth.php';
class BakedTwitter extends Module
{
	private $_html = '';
	private $_postErrors = array();
	
    public function __construct()
    {
        $this->name = 'bakedtwitter';
    	$this->tab = 'front_office_features';
		$this->author = 'Baked Themes';
        $this->version = 1.0;
		$this->bootstrap = true;

        parent::__construct();

        /* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Baked Twitter');
        $this->description = $this->l('Display twitter feed on the homepage');
		$this->full_url = _MODULE_DIR_.$this->name.'/';
		
		$config = Configuration::getMultiple(array('PS_TWITTER_USERNAME'));
		if (empty($config['PS_TWITTER_USERNAME']))
			$this->warning = $this->l('Please insert your Twitter username, no need to use the @ symbol');		
			}

    function install()
    {
        if (!parent::install() OR !$this->registerHook('displayHome') OR  !$this->registerHook('displayHeader')
			OR !Configuration::updateValue('PS_TWITTER_USERNAME', 'bakedthemes')
			)
			return false;
		return true;
    }
	public function uninstall()
	{
		if (!Configuration::deleteByName('PS_TWITTER_USERNAME')
		    OR !parent::uninstall())
			return false;
		return true;
	}	
   public function hookDisplayHome($params)
    {
		global $smarty;
		
		# Create the connection
		$twitter = new TwitterOAuth(Configuration::get('PS_CONSUMER_KEY'), Configuration::get('PS_CONSUMER_SECRET'), Configuration::get('PS_ACCESS_TOKEN'), Configuration::get('PS_ACCESS_TOKEN_SECRET'));

		# Migrate over to SSL/TLS
		$twitter->ssl_verifypeer = true;

		# Load the Tweets
		$tweets = $twitter->get('statuses/user_timeline', array('screen_name' => Configuration::get('PS_TWITTER_USERNAME'), 'exclude_replies' => 'true', 'include_rts' => 'false', 'count' => Configuration::get('PS_TWEET_LIMIT')));
		$filled_data = array();
		# Example output
		if(!empty($tweets)) {
			foreach($tweets as $tweet) {

				# Access as an object
				$tweet_text = $tweet->text;

				# Make links active
				$tweet_text = preg_replace("#(http://|(www.))(([^s<]{4,68})[^s<]*)#", '<a href="http://$2$3" target="_blank">$1$2$4</a>', $tweet_text);

				# Linkify user mentions
				$tweet_text = preg_replace('/(?<=^|\s)@([a-z0-9_]+)/i','<a href="http://www.twitter.com/$1">@$1</a>', $tweet_text);

				# Linkify tags
				$tweet_text = preg_replace("/\#([a-zA-Z0-9_]+)/", '<a href="https://twitter.com/hashtag/Marketing?src=$1" target="_blank">#$1</a>', $tweet_text);

				# Output
				$filled_data[] = $tweet_text;

			}
		}
		
		$smarty->assign('username', Configuration::get('PS_TWITTER_USERNAME'));
		$smarty->assign('filled_data', $filled_data);
		$smarty->assign('this_path', $this->_path);
		return $this->display(__FILE__, 'bakedtwitter.tpl');
	}
	
		public function hookFooter($params)
	{
		return $this->hookDisplayHome($params);
	}
	
		public function hookDisplayHeader($params)
	{
		$this->context->controller->addCss($this->_path.'bakedtwitter.css');
		$this->context->controller->addJS($this->_path.'bakedtwitter.js');
	}
	
	public function _displayForm()
	{

		$this->_html .= '
		<div id="bakedform" class="panel">
		<h3>'.$this->l('To create Twitter APP, access to this link:').'<a target="_blank" href="https://apps.twitter.com/">https://apps.twitter.com/</a></h3>
		<form  class="width2" action="'.$_SERVER['REQUEST_URI'].'" method="post" style="margin-bottom:10px;">
			<fieldset><div class="panel-heading">'.$this->l('Settings').'</div>
				<label>'.$this->l('Twitter username').'</label>
				<div class="margin-form"><input type="text" name="twitterusername" id="twitterusername" value="'.Configuration::get('PS_TWITTER_USERNAME').'" size="50" style="width:300px">
					<p class="clear">'.$this->l('Enter your twitter username, no need to use the @ symbol').'</p>
				</div>				
				<br />
				<label>'.$this->l('TWEET LIMIT').'</label>
				<div class="margin-form"><input type="text" name="tweet_limit" id="tweet_limit" value="'.Configuration::get('PS_TWEET_LIMIT').'" size="50" style="width:300px">
				</div>
				<br />
				<label>'.$this->l('TWEET CONSUMER KEY').'</label>
				<div class="margin-form"><input type="text" name="consumer_key" id="consumer_key" value="'.Configuration::get('PS_CONSUMER_KEY').'" size="50" style="width:300px">
				</div>
				<br />
				<label>'.$this->l('TWEET ACCESS TOKEN').'</label>
				<div class="margin-form"><input type="text" name="access_token" id="access_token" value="'.Configuration::get('PS_ACCESS_TOKEN').'" size="50" style="width:300px">					
				</div>
				<br />
				<label>'.$this->l('TWEET CONSUMER SECRET').'</label>
				<div class="margin-form"><input type="text" name="consumer_secret" id="consumer_secret" value="'.Configuration::get('PS_CONSUMER_SECRET').'" size="50" style="width:300px">					
				</div>
				<br />
				<label>'.$this->l('TWEET ACCESS TOKEN SECRET').'</label>
				<div class="margin-form"><input type="text" name="access_token_secret" id="access_token_secret" value="'.Configuration::get('PS_ACCESS_TOKEN_SECRET').'" size="50" style="width:300px">					
				</div>		
				<br />	
				<input type="submit" name="btnSetting" value="'.$this->l('Save').'" class="btn btn-default" />
			</fieldset>
		</form>
		</div>';
	}
	private function _postValidation()
	{
		if (isset($_POST['btnSetting']))
		{
			if (empty($_POST['twitterusername']))
				$this->_postErrors[] = '<p>'.$this->l('Please insert your Twitter username').'</p>';				
			if (empty($_POST['tweet_limit']))
				$this->_postErrors[] = '<p>'.$this->l('Please insert your Twitter Limit').'</p>';
			if (empty($_POST['consumer_key']))
				$this->_postErrors[] = '<p>'.$this->l('Please insert your Twitter Consumer Key').'</p>';
			if (empty($_POST['access_token']))
				$this->_postErrors[] = '<p>'.$this->l('Please insert your Twitter Access Token').'</p>';
			if (empty($_POST['consumer_secret']))
				$this->_postErrors[] = '<p>'.$this->l('Please insert your Twitter Consumer Secret').'</p>';	
			if (empty($_POST['access_token_secret']))
				$this->_postErrors[] = '<p>'.$this->l('Please insert your Twitter Cccess Token Secret').'</p>';		
		}
	}	
	private function _postProcess()
	{
		if(isset($_POST['btnSetting']))
		{
	 		Configuration::updateValue('PS_TWITTER_USERNAME', $_POST['twitterusername']);
	 		Configuration::updateValue('PS_TWEET_LIMIT', $_POST['tweet_limit']);
	 		Configuration::updateValue('PS_CONSUMER_KEY', $_POST['consumer_key']);
	 		Configuration::updateValue('PS_ACCESS_TOKEN', $_POST['access_token']);
	 		Configuration::updateValue('PS_CONSUMER_SECRET', $_POST['consumer_secret']);
	 		Configuration::updateValue('PS_ACCESS_TOKEN_SECRET', $_POST['access_token_secret']);
			//$this->_html .= '<div class="conf confirm">'.$this->l('Saved').'</div>';
		}
		
	}	
	public function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('btnSetting'))	
		//if (!empty($_POST) || isset($_GET['delete']) )
		{

			$this->_postValidation();
			if (!sizeof($this->_postErrors))
				$this->_postProcess();					
			else
				foreach ($this->_postErrors AS $err)
					$this->_html .= '<div class="alert error">'. $err .'</div>';
		}
		$this->_displayForm();
		return $this->_html;
	}	
	
}