<?php

class BakedTestimonialTestimonialsModuleFrontController extends ModuleFrontController
{
	/**
	 * @see FrontController::initContent()
	 */
	public function initContent() 
	{
		parent::initContent();		
		$this->displayTestimonials();		
	}
	
	public function displayTestimonials()
	{
			
		$output = array(); // create an array named $output to store our testimonials. We will read the from the DB
		$db = Db::getInstance(); // create and object to represent the database
		$result = $db->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'testimonials`;'); // Query to count the total number of testimonials
		if ($result == true) {
			$numrows = 0;
			foreach ($result as $key => $row) {
		 		$numrows++;
		 	}		
		} else {
			$numrows = 1;
		}
		
        $nextpage = "";
		$prevpage = "";
		// number of rows to show per page
		$rowsperpage = Configuration::get('TESTIMONIAL_PERPAGE');

		// find out total pages
		$totalpages = ceil($numrows / $rowsperpage);
				// get the current page or set a default
				if (isset($_GET['currentpage']) && is_numeric($_GET['currentpage'])) {
				   // cast var as int
				   $currentpage = (int) $_GET['currentpage'];
				} else {
				   // default page num
				   $currentpage = 1;
				} // end if

				// the offset of the list, based on current page 
				$offset = ($currentpage - 1) * $rowsperpage;
				
			   // get the info from the db 

				$result = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'testimonials` WHERE status = "enabled" ORDER BY testimonial_id DESC LIMIT '.$offset.', '.$rowsperpage.';'); // Query to return the testimonials on that page
				// while there are rows to be fetched...
				foreach ($result as $key => $data) {
		     		$time = $result[$key]["date_added"];
		     		$t = explode(" ", $time);
		     		$result[$key]["date_added"] = date("d F Y", strtotime($t[0]));     		
		     	} 
				if ($result != false) {
					foreach ($result as $key => $row) {
						$results[] = $row;
						$time = $result[$key]["date_added"];
			     		$t = explode(" ", $time);
			     		$result[$key]["date_added"] = date("d F Y", strtotime($t[0]));  				 		
				 	}
				} else {
					$results[] = "";
					}
				  
		/****** pagination links ******/
		// range of num links to show
			$range = 3;

			// if not on page 1, don't show back links
			if ($currentpage > 1) {
			   // show << link to go back to page 1
			   
			   // get previous page num
			   $prevpage = $currentpage - 1;
			   // show < link to go back to 1 page
			} // end if 

			// if not on last page, show forward and last page links        
			if ($currentpage != $totalpages) {
			   // get next page
			   $nextpage = $currentpage + 1;
	
		} // end if
		/****** end pagination links ******/
		$this->context->smarty->assign(array(
			  'http_host' => $_SERVER['HTTP_HOST'],
			  'this_path' => $this->module->getPathUri(),
			  'base_dir'=> __PS_BASE_URI__,
					  'testimonials' => $results,
					  'currentpage' => $currentpage,
					  'prevpage' => $prevpage,
					  'nextpage' => $nextpage,
					  'totalpages' => $totalpages
			));
				  
		$this->setTemplate('displaytestimonials.tpl');
	 }
}