<?php
/*
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2014 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class bakedparallax extends Module
{
	public function __construct()
	{
		$this->name = 'bakedparallax';
		$this->tab = 'front_office_features';
		$this->version = '1';
		$this->author = 'Baked Themes';
		$this->need_instance = 0;
		$this->bootstrap = true;

		parent::__construct();

		$this->displayName = $this->l('Baked Parallax');
		$this->description = $this->l('Add a parallax advert area to the homepage.');
		$path = dirname(__FILE__);
		if (strpos(__FILE__, 'Module.php') !== false)
			$path .= '/../modules/'.$this->name;
		include_once $path.'/bakedparallaxClass.php';
	}

	public function install()
	{
		if (!parent::install() || !$this->registerHook('displayHome') || !$this->registerHook('displayHeader'))
			return false;

		$res = Db::getInstance()->execute(
			'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bakedparallax` (
			`id_bakedparallax` int(10) unsigned NOT NULL auto_increment,
			`id_shop` int(10) unsigned NOT NULL ,
			`body_home_logo_link` varchar(255) NOT NULL,
			`body_home_logo_link1` varchar(255) NOT NULL,
			PRIMARY KEY (`id_bakedparallax`))
			ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8'
		);

		if ($res)
			$res &= Db::getInstance()->execute(
				'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bakedparallax_lang` (
				`id_bakedparallax` int(10) unsigned NOT NULL,
				`id_lang` int(10) unsigned NOT NULL,
				`body_title` varchar(255) NOT NULL,
				`body_subheading` varchar(255) NOT NULL,
				`body_paragraph` text NOT NULL,
				`body_logo_subheading` varchar(255) NOT NULL,
				`body_logo_subheading1` varchar(255) NOT NULL,
				PRIMARY KEY (`id_bakedparallax`, `id_lang`))
				ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8'
			);

		if ($res)
			foreach (Shop::getShops(false) as $shop)
				$res &= $this->createExamplebakedparallax($shop['id_shop']);

		if (!$res)
			$res &= $this->uninstall();

		return (bool)$res;
	}

	private function createExamplebakedparallax($id_shop)
	{
		$bakedparallax = new bakedparallaxClass();
		$bakedparallax->id_shop = (int)$id_shop;
		$bakedparallax->body_home_logo_link = 'http://pretzel.bakedthemes.com';
		$bakedparallax->body_home_logo_link1 = 'http://pretzel.bakedthemes.com';
		foreach (Language::getLanguages(false) as $lang)
		{
			$bakedparallax->body_title[$lang['id_lang']] = 'PRETZELS DISCOUNT CODES AND OFFERS';
			$bakedparallax->body_subheading[$lang['id_lang']] = 'Check back regular to find the latest deals and offers';
			$bakedparallax->body_paragraph[$lang['id_lang']] = '<h1>WEEKLY FLASH SALE</h1>';
			$bakedparallax->body_logo_subheading[$lang['id_lang']] = 'GET YOUR CODE';
			$bakedparallax->body_logo_subheading1[$lang['id_lang']] = 'SHOP THE LATEST';
		}

		return $bakedparallax->add();
	}

	public function uninstall()
	{
		$res = Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'bakedparallax`');
		$res &= Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'bakedparallax_lang`');

		if ($res == 0 || !parent::uninstall())
			return false;

		return true;
	}

	private function initForm()
	{
		$languages = Language::getLanguages(false);
		foreach ($languages as $k => $language)
			$languages[$k]['is_default'] = (int)$language['id_lang'] == Configuration::get('PS_LANG_DEFAULT');

		$helper = new HelperForm();
		$helper->module = $this;
		$helper->name_controller = 'bakedparallax';
		$helper->identifier = $this->identifier;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->languages = $languages;
		$helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
		$helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
		$helper->allow_employee_form_lang = true;
		$helper->toolbar_scroll = true;
		$helper->toolbar_btn = $this->initToolbar();
		$helper->title = $this->displayName;
		$helper->submit_action = 'submitUpdatebakedparallax';

		$file = dirname(__FILE__).'/img/homepage_logo_'.(int)$this->context->shop->id.'.jpg';
		$logo = (file_exists($file) ? '<img src="'.$this->_path.'img/homepage_logo_'.(int)$this->context->shop->id.'.jpg">' : '');

		$this->fields_form[0]['form'] = array(
			'tinymce' => true,
			'legend' => array(
				'title' => $this->displayName
			),
			'submit' => array(
				'name' => 'submitUpdatebakedparallax',
				'title' => $this->l('Save '),
				'class' => 'button pull-right'
			),
			'input' => array(
				array(
					'type' => 'text',
					'label' => $this->l('Advert title'),
					'name' => 'body_title',
					'lang' => true,
					'size' => 64,
					'desc' => $this->l(''),
				),
			
				array(
					'type' => 'textarea',
					'label' => $this->l('Advert text'),
					'name' => 'body_paragraph',
					'lang' => true,
					'autoload_rte' => true,
					'desc' => $this->l('Add the content of your offer.'),
					'cols' => 60,
					'rows' => 30
				),
				array(
					'type' => 'text',
					'label' => $this->l('Subheading'),
					'name' => 'body_subheading',
					'lang' => true,
					'size' => 64,
					'desc' => $this->l(''),
				),
				array(
					'type' => 'file',
					'label' => $this->l('Background Image'),
					'name' => 'body_homepage_logo',
					'display_image' => true,
					'image' => $logo,
					'delete_url' => 'index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&deleteLogoImage=1'
				),
				array(
					'type' => 'text',
					'label' => $this->l('First Button Link'),
					'name' => 'body_home_logo_link',
					'size' => 33,
				),
				array(
					'type' => 'text',
					'label' => $this->l('First Button Text'),
					'name' => 'body_logo_subheading',
					'lang' => true,
					'size' => 33,
				),
				array(
					'type' => 'text',
					'label' => $this->l('Second Button Link'),
					'name' => 'body_home_logo_link1',
					'size' => 33,
				),
				array(
					'type' => 'text',
					'label' => $this->l('Second Button Text'),
					'name' => 'body_logo_subheading1',
					'lang' => true,
					'size' => 33,
				),
			)
		);

		return $helper;
	}

	private function initToolbar()
	{
		$this->toolbar_btn['save'] = array(
			'href' => '#',
			'desc' => $this->l('Save')
		);

		return $this->toolbar_btn;
	}

	public function getContent()
	{
		$this->_html = '';
		$this->postProcess();

		$helper = $this->initForm();

		$id_shop = (int)$this->context->shop->id;
		$bakedparallax = bakedparallaxClass::getByIdShop($id_shop);

		if (!$bakedparallax) //if bakedparallax ddo not exist for this shop => create a new example one
			$this->createExamplebakedparallax($id_shop);

		foreach ($this->fields_form[0]['form']['input'] as $input) //fill all form fields
		{
			if ($input['name'] != 'body_homepage_logo')
				$helper->fields_value[$input['name']] = $bakedparallax->{$input['name']};
		}

		$file = dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg';
		$helper->fields_value['body_homepage_logo']['image'] = (file_exists($file) ? '<img src="'.$this->_path.'img/homepage_logo_'.(int)$id_shop.'.jpg">' : '');
		if ($helper->fields_value['body_homepage_logo'] && file_exists($file))
			$helper->fields_value['body_homepage_logo']['size'] = filesize($file) / 1000;

		$this->_html .= $helper->generateForm($this->fields_form);

		return $this->_html;
	}

	public function postProcess()
	{
		$errors = '';
		$id_shop = (int)$this->context->shop->id;
		// Delete logo image retrocompat 1.5
		if (Tools::isSubmit('deleteLogoImage') || Tools::isSubmit('deleteImage'))
		{
			if (!file_exists(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg'))
				$errors .= $this->displayError($this->l('This action cannot be made.'));
			else
			{
				unlink(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg');
				Configuration::updateValue('bakedparallax_IMAGE_DISABLE', 1);
				$this->_clearCache('bakedparallax.tpl');
				Tools::redirectAdmin('index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)Tab::getIdFromClassName('AdminModules').(int)$this->context->employee->id));
			}
			$this->_html .= $errors;
		}

		if (Tools::isSubmit('submitUpdatebakedparallax'))
		{
			$id_shop = (int)$this->context->shop->id;
			$bakedparallax = bakedparallaxClass::getByIdShop($id_shop);
			$bakedparallax->copyFromPost();
			if (empty($bakedparallax->id_shop))
				$bakedparallax->id_shop = (int)$id_shop;
			$bakedparallax->save();

			/* upload the image */
			if (isset($_FILES['body_homepage_logo']) && isset($_FILES['body_homepage_logo']['tmp_name']) && !empty($_FILES['body_homepage_logo']['tmp_name']))
			{
				Configuration::set('PS_IMAGE_GENERATION_METHOD', 1);
				if (file_exists(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg'))
					unlink(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg');
				if ($error = ImageManager::validateUpload($_FILES['body_homepage_logo']))
					$errors .= $error;
				elseif (!($tmp_name = tempnam(_PS_TMP_IMG_DIR_, 'PS')) || !move_uploaded_file($_FILES['body_homepage_logo']['tmp_name'], $tmp_name))
					return false;
				elseif (!ImageManager::resize($tmp_name, dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg'))
					$errors .= $this->displayError($this->l('An error occurred while attempting to upload the image.'));
				if (isset($tmp_name))
					unlink($tmp_name);
			}
			$this->_html .= $errors == '' ? $this->displayConfirmation($this->l('Settings updated successfully.')) : $errors;
			if (file_exists(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg'))
			{
				list($width, $height, $type, $attr) = getimagesize(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg');
				Configuration::updateValue('bakedparallax_IMAGE_WIDTH', (int)round($width));
				Configuration::updateValue('bakedparallax_IMAGE_HEIGHT', (int)round($height));
				Configuration::updateValue('bakedparallax_IMAGE_DISABLE', 0);
			}
			$this->_clearCache('bakedparallax.tpl');
			Tools::redirectAdmin('index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)Tab::getIdFromClassName('AdminModules').(int)$this->context->employee->id));
		}

		return true;
	}

	public function hookDisplayHome($params)
	{
		if (!$this->isCached('bakedparallax.tpl', $this->getCacheId()))
		{
			$id_shop = (int)$this->context->shop->id;
			$bakedparallax = bakedparallaxClass::getByIdShop($id_shop);
			if (!$bakedparallax)
				return;
			$bakedparallax = new bakedparallaxClass((int)$bakedparallax->id, $this->context->language->id);
			if (!$bakedparallax)
				return;
			$this->smarty->assign(
				array(
					'bakedparallax' => $bakedparallax,
					'default_lang' => (int)$this->context->language->id,
					'image_width' => Configuration::get('bakedparallax_IMAGE_WIDTH'),
					'image_height' => Configuration::get('bakedparallax_IMAGE_HEIGHT'),
					'id_lang' => $this->context->language->id,
					'homepage_logo' => !Configuration::get('bakedparallax_IMAGE_DISABLE') && file_exists('modules/bakedparallax/img/homepage_logo_'.(int)$id_shop.'.jpg'),
					'image_path' => $this->_path.'img/homepage_logo_'.(int)$id_shop.'.jpg'
				)
			);
		}

		return $this->display(__FILE__, 'bakedparallax.tpl', $this->getCacheId());
	}

	public function hookdisplayTopColumn($params)
	{
		if (!isset($this->context->controller->php_self) || $this->context->controller->php_self != 'index')
			return;
		return $this->hookDisplayHome($params);
	}

	public function hookDisplayHeader()
	{
		if (!isset($this->context->controller->php_self) || $this->context->controller->php_self != 'index')
			return;
		$this->context->controller->addCSS(($this->_path).'css/bakedparallax.css', 'all');
	}
}