<?php


class  bakednewsletter extends Module
{
	public $error = false;
	public $valid = false;
	public $ckPath;
	public $ckDomain;

	protected $allowed_exts = array('gif', 'jpeg', 'jpg', 'png');
	protected $max_upload_file_size = 2048;

	public function __construct()
	{
		$this->name = 'bakednewsletter';
		$this->tab = 'front_office_features';
		$this->version = '1';
		$this->author = 'Baked Themes';
		$this->bootstrap = true;
		$this->base = dirname(__FILE__);

		parent::__construct();

		$this->displayName = $this->l('Baked Newsletter Popup');
		$this->description = $this->l('Newsletter registration popup');


		$this->ckPath = trim(__PS_BASE_URI__.$this->ckPath, '/\\').'/';
		if ($this->ckPath{0} != '/') $this->ckPath = '/'.$this->ckPath;
		$this->ckPath = rawurlencode($this->ckPath);
		$this->ckPath = str_replace('%2F', '/', $this->ckPath);
		$this->ckPath = str_replace('%7E', '~', $this->ckPath);
		$this->ckDomain = $this->getDomain();
		if (_PS_VERSION_ >= '1.5')
			$cookie = new Cookie('ps');
	}

	public function install()
	{
		if (!Db::getInstance()->getValue('SELECT 1 FROM information_schema.TABLES ist WHERE ist.TABLE_NAME = \''._DB_PREFIX_.'newsletter\' AND ist.TABLE_SCHEMA = \''._DB_NAME_.'\''))
		{
			if (_PS_VERSION_ >= '1.5') {
				Db::getInstance()->execute('
				CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'newsletter` (
					`id` int(6) NOT NULL AUTO_INCREMENT,
					`id_shop` INTEGER UNSIGNED NOT NULL DEFAULT \'1\',
					`id_shop_group` INTEGER UNSIGNED NOT NULL DEFAULT \'1\',
					`email` varchar(255) NOT NULL,
					`newsletter_date_add` DATETIME NULL,
					`ip_registration_newsletter` varchar(15) NOT NULL,
					`http_referer` VARCHAR(255) NULL,
					`active` TINYINT(1) NOT NULL DEFAULT \'0\',
					PRIMARY KEY(`id`)
				) ENGINE='._MYSQL_ENGINE_.' default CHARSET=utf8');
			}
			else {
				Db::getInstance()->Execute('
				CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'newsletter` (
					`id` int(6) NOT NULL AUTO_INCREMENT,
					`email` varchar(255) NOT NULL,
					`newsletter_date_add` DATETIME NULL,
					`ip_registration_newsletter` varchar(15) NOT NULL,
					`http_referer` VARCHAR(255) NULL,
					`active` TINYINT(1) NOT NULL DEFAULT \'0\',
					PRIMARY KEY(`id`)
				) ENGINE='._MYSQL_ENGINE_.' default CHARSET=utf8');
			}
		}
		else
		{
			if (!Db::getInstance()->getValue('SELECT 1 FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = \''._DB_NAME_.'\' AND TABLE_NAME = \''._DB_PREFIX_.'newsletter\' AND COLUMN_NAME = \'active\''))
			{
				if (!DB::getInstance()->Execute('ALTER TABLE `'._DB_PREFIX_.'newsletter` ADD (active TINYINT(1) NOT NULL DEFAULT \'0\')') ||
						!DB::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'newsletter` SET active = \'1\'')) {
					$this->saveLog('INSTALL - Can\'t alter table');
					return false;
				}
			}
		}

		Db::getInstance()->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'ctk_np_advertising`');
		foreach ($this->_installDB() as $s) {
			if (!Db::getInstance()->Execute($s)) {
				$this->saveLog('INSTALL - Can\'t install database');
				return false;
			}
		}

		foreach ($this->loadVars() as $keyConfiguration => $name) {
			if (!Configuration::updateValue($keyConfiguration, $name)) {
				$this->saveLog('INSTALL - Can\'t insert configuration variables');
				return false;
			}
		}

		if (!parent::install() OR !$this->registerHook('displayTop')) {
			$this->saveLog('INSTALL - Can\'t install');
			return false;
		}

		if (_PS_VERSION_ >= '1.5') {
			if (!$this->registerHook('displayMobileHeader'))
				$this->saveLog('INSTALL - Can\'t install mobile');
		}

		return true;
	}

	public function uninstall()
	{
		Db::getInstance()->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'ctk_np_advertising`');

		foreach ($this->loadVars() as $keyConfiguration => $name) {
			if (!Configuration::deleteByName($keyConfiguration)) {
				$this->saveLog('UNINSTALL - Can\'t delete configuration variables');
				return false;
			}
		}

		if (!parent::uninstall()) {
			$this->saveLog('UNINSTALL - Can\'t uninstall');
			return false;
		}
		return true;
	}

	public function getContent()
	{
		if (Tools::isSubmit('submitUpdate'))
		{
			$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));

			if (isset($_POST['in_all_pages']) AND Validate::isBool((int)($_POST['in_all_pages'])))
				Configuration::updateValue('CTK_NP_IN_ALL_PAGES', $_POST['in_all_pages']);
			if (isset($_POST['pages_to_show']))
				Configuration::updateValue('CTK_NP_PAGES_TO_SHOW', implode(',', $_POST['pages_to_show']));
			else
				Configuration::updateValue('CTK_NP_PAGES_TO_SHOW', '');
			if (isset($_POST['detect_subs']) AND Validate::isBool((int)($_POST['detect_subs'])))
				Configuration::updateValue('CTK_NP_DETECT_SUBS', $_POST['detect_subs']);
			if (isset($_POST['once_per_visit']) AND Validate::isInt((int)($_POST['once_per_visit'])))
				Configuration::updateValue('CTK_NP_ONCE_PER_VISIT', $_POST['once_per_visit']);
			if (isset($_POST['cookie_time']) AND Validate::isInt((int)($_POST['cookie_time'])))
				Configuration::updateValue('CTK_NP_COOKIE_DAYS', $_POST['cookie_time']);
			if (isset($_POST['verif_email']) AND Validate::isBool((int)($_POST['verif_email'])))
				Configuration::updateValue('CTK_NP_VERIFICATION_EMAIL', $_POST['verif_email']);
			if (isset($_POST['conf_email']) AND Validate::isBool((int)($_POST['conf_email'])))
				Configuration::updateValue('CTK_NP_CONFIRMATION_EMAIL', $_POST['conf_email']);
			if (isset($_POST['opt_res_design']) AND Validate::isInt((int)($_POST['opt_res_design'])))
				Configuration::updateValue('CTK_NP_OPT_RDESIGN', $_POST['opt_res_design']);
			if (isset($_POST['opt_old_ps']) AND Validate::isInt((int)($_POST['opt_old_ps'])))
				Configuration::updateValue('CTK_NP_OPT_OLD_PS', $_POST['opt_old_ps']);

			if (isset($_POST['in_all_pages']) AND $_POST['in_all_pages'] == 0)
			{
				if (!isset($_POST['pages_to_show']) OR empty($_POST['pages_to_show']))
					$this->_html .= $err[] = $this->displayError($this->l('Need select at least one page to show the popup'));
			}
			else
				Configuration::updateValue('CTK_NP_PAGES_TO_SHOW', '');

			if (isset($_POST['show_terms']) AND Validate::isBool((int)($_POST['show_terms'])))
			{
				Configuration::updateValue('CTK_NP_SHOW_TERMS', $_POST['show_terms']);
				if ($_POST['show_terms'] == 1)
				{
					if (isset($_POST['id_cms_terms']))
					{
						Configuration::updateValue('CTK_NP_ID_CMS_TERMS', $_POST['id_cms_terms']);
						if (isset($_POST['show_terms']) AND $_POST['show_terms'] == 1 AND $_POST['id_cms_terms'] == 0)
							$this->_html .= $err[] = $this->displayError($this->l('Need select one page for terms and conditions'));
					}
				}
				else
					Configuration::updateValue('CTK_NP_ID_CMS_TERMS', '0');
			}

			if (!$this->_addContent())
				$this->_html .= $err[] = $this->displayError($this->l('An error occurred while saving advertising content.'));
			if (isset($_POST['show_advertising']) AND Validate::isBool((int)($_POST['show_advertising'])))
			{
				Configuration::updateValue('CTK_NP_SHOW_ADVERTISING', $_POST['show_advertising']);
				if ($_POST['show_advertising'] == 1)
					if (empty($_POST['advertising_'.$defaultLanguage]))
						$this->_html .= $err[] = $this->displayError($this->l('You must enter the advertising, at least on your default language.'));
			}

			if (isset($_POST['advertising_in_responsive']) AND Validate::isBool((int)($_POST['advertising_in_responsive'])))
				Configuration::updateValue('CTK_NP_ADVERTISING_IN_RESPONSIVE', $_POST['advertising_in_responsive']);
			else
				Configuration::updateValue('CTK_NP_ADVERTISING_IN_RESPONSIVE', '0');

			if (isset($_POST['send_voucher']) AND Validate::isInt((int)($_POST['send_voucher'])) AND $_POST['send_voucher'] == 1)
			{
				if (!isset($_POST['voucher_type']))
					$this->_html .= $err[] = $this->displayError($this->l('Need select one type of voucher'));
				else
				{
					Configuration::updateValue('CTK_NP_VOUCHER_TYPE', $_POST['voucher_type']);
					if ($_POST['voucher_type'] == 1) {
						if (empty($_POST['voucher']) OR !Validate::isDiscountName($_POST['voucher']))
							$this->_html .= $err[] = $this->displayError($this->l('Voucher code is invalid'));
						else
							Configuration::updateValue('CTK_NP_VOUCHER_CODE', $_POST['voucher']);
					}
					elseif ($_POST['voucher_type'] == 2) {
						if (empty($_POST['voucher_up_amount']) OR !Validate::isFloat(($_POST['voucher_up_amount'])))
							$this->_html .= $err[] = $this->displayError($this->l('Discount amount invalid'));
						else
							Configuration::updateValue('CTK_NP_VOUCHER_UP_AMOUNT', $_POST['voucher_up_amount']);
						if (empty($_POST['voucher_up_days']) OR !Validate::isInt(($_POST['voucher_up_days'])))
							$this->_html .= $err[] = $this->displayError($this->l('Discount validity invalid'));
						else
							Configuration::updateValue('CTK_NP_VOUCHER_UP_DAYS', $_POST['voucher_up_days']);
					}
				}
			}
			else
			{
				Configuration::updateValue('CTK_NP_VOUCHER_TYPE', '');
				Configuration::updateValue('CTK_NP_VOUCHER_CODE', '');
				Configuration::updateValue('CTK_NP_VOUCHER_UP_AMOUNT', '');
				Configuration::updateValue('CTK_NP_VOUCHER_UP_DAYS', '');
			}
			Configuration::updateValue('CTK_NP_SEND_VOUCHER', $_POST['send_voucher']);

			if ($_FILES['background_image']['name'])
			{
				$temp				 = explode('.', $_FILES['background_image']['name']);
				$extension			 = end($temp);
				if ($_FILES['background_image']['error'] > 0)
					$output .= '<div class="alert error">'.$_FILES['file']['error']."</div>";
			elseif (($_FILES['background_image']['size'] / 1024) < $this->max_upload_file_size && in_array($extension, $this->allowed_exts))
				{
						$newfilename = 'newsletter_bg.jpg';
						//.end($temp);
						if (move_uploaded_file($_FILES['background_image']['tmp_name'], _PS_MODULE_DIR_.'/'.$this->name."/css/".$newfilename))
						{
							Configuration::updateValue('CTK_NP_BACKGROUND_IMG', $newfilename);
						}
				}
				else
					$output .= '<div class="alert error">'.$this->l('Invalid file')."</div>";
			}

			if (/*($_POST['verif_email'] == 1) OR */($_POST['send_voucher'] == 1))
				Configuration::updateValue('CTK_NP_CONFIRMATION_EMAIL', 0);

			if (isset($_POST['delay_popup']) AND !Validate::isInt($_POST['delay_popup']) OR ($_POST['delay_popup'] < 0))
				$this->_html .= $err[] = $this->displayError($this->l('Number invalid in delay to show'));
			else
				Configuration::updateValue('CTK_NP_DELAY_POPUP', $_POST['delay_popup']);

			if (!isset($err))
				$this->_html .= $this->displayConfirmation($this->l('Configuration updated.'));
		}

		return $this->_displayForm();
	}


	public function renderForm()
	{
		if (Configuration::get('CTK_NP_PAGES_TO_SHOW'))
			$pagesSaved = explode(',', Configuration::get('CTK_NP_PAGES_TO_SHOW'));
		$pages = array();
		$i = 0;
		foreach ($this->loadPages() as $pageKey => $pageName)
		{
			$pages[$i]['id'] = $pageKey;
			$pages[$i]['name'] = $pageName;
			$i++;
		}
		$fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Settings'),
					'image' => '/modules/bakednewsletter/logo.gif',
				),
				'input' => array(
					array(
						'type' => 'switch',
						'label' => $this->l('Show popup on any page?'),
						'name' => 'in_all_pages',
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
					),

					array (
						'type' => 'select',
						'label' => $this->l('Select which pages the popup will show.'),
						'name' => 'pages_to_show[]',
						'multiple' => 1,
						'options' => array(
							'query' => $pages,
							'id' => 'id',
							'name' => 'name',
						),


					),
					array(
						'type' => 'switch',
						'label' => $this->l('Detect if a customer is already subscribed and don\'t show the popup?'),
						'name' => 'detect_subs',
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
					),

					array(
						'type' => 'select',
						'label' => $this->l('When to display the popup?'),
						'name' => 'cookie_time',
						'options' => array(
							'query' => array(
								array(
									'id' => 30,
									'name' => $this->l('30 days')
								),
								array(
									'id' => 15,
									'name' => $this->l('15 days')
								),
								array(
									'id' => 7,
									'name' => $this->l('7 days')
								),
								array(
									'id' => 1,
									'name' => $this->l('1 day')
								),
								array(
									'id' => 0,
									'name' => $this->l('On browser close')
								)
							),
							'id' => 'id',
							'name' => 'name',
						)
					),

					array(
						'type' => 'select',
						'label' => $this->l('When to reset the preferences?'),
						'name' => 'once_per_visit',
						'options' => array(
							'query' => array(
								array(
									'id' => 2,
									'name' => $this->l('Optional, do not show again')
								),
								array(
									'id' => 1,
									'name' => $this->l('Optional, do not show again')
								),
								array(
									'id' => 0,
									'name' => $this->l('All time')
								)
							),
							'id' => 'id',
							'name' => 'name',
						)
					),

					array(
						'type' => 'switch',
						'label' => $this->l('Send verification e-mail after subscription?'),
						'name' => 'verif_email',
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
					),

					array(
						'type' => 'switch',
						'label' => $this->l('Send confirmation e-mail after subscription?'),
						'name' => 'conf_email',
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
					),

					array(
						'type' => 'text',
						'label' => $this->l('Welcome voucher code'),
						'name' => 'once_per_visit',
						'class' => 'fixed-width-md',
						'desc' => $this->l('Leave blank to disable by default.')
					),
				),
				'submit' => array(
					'title' => $this->l('Save'),
				)
			),
		);

		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table = $this->table;
		$lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
		$helper->default_form_language = $lang->id;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submitUpdate';
		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			//'fields_value' => $this->getConfigFieldsValues(),
			'fields_value' => array(),
			'languages' => $this->context->controller->getLanguages(),
			'id_language' => $this->context->language->id
		);

		return $helper->generateForm(array($fields_form));
	}

	private function _displayForm()
	{
		global $cookie;

		$iso = Language::getIsoById((int)($cookie->id_lang));
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$cmss = CMS::listCms((int)($cookie->id_lang));

		foreach ($languages as $language)
			if (!file_exists($this->base.'/mails/'.$language['iso_code']))
				$missingMails[] = $language['name'];

		if (Configuration::get('CTK_NP_PAGES_TO_SHOW'))
			$pagesSaved = explode(',', Configuration::get('CTK_NP_PAGES_TO_SHOW'));

		//$this->_html .= $this->renderForm();
		$this->_html .= '
		<script>
		var backend = 1;
		</script>
		<script type="text/javascript" src="'.$this->_path.'js/'.$this->CTKSript().'"></script>
		<script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/jquery.multiselect/jquery-ui.min.js"></script>
		<link rel="stylesheet" type="text/css" href="'.$this->_path.'css/jquery.multiselect/jquery.multiselect.css"/>
		<link rel="stylesheet" type="text/css" href="'.$this->_path.'css/jquery.multiselect/jquery-ui.css"/>
		<script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/jquery.multiselect/jquery.multiselect.min.js"></script>
		<script type="text/javascript">
			$(function(){
				$("#pages_to_show").multiselect({
					minWidth: 250,
					height: 165,
					checkAllText: "'.$this->l('Check all').'",
					uncheckAllText: "'.$this->l('Uncheck all').'",
					noneSelectedText: "'.$this->l('Select pages').'",
					selectedText: "# '.$this->l('selected(s)').'"
				});
			});
		</script>
		<form method="post" action="'.$_SERVER['REQUEST_URI'].'" enctype="multipart/form-data" style="width: 600px; margin:auto; padding: 10px; border: 1px solid #dbdbdb; border-radius: 3px">
			<fieldset>';


				if (isset($missingMails)) {
					$this->_html .= '<div class="hint" style="display: block; padding-left: 40px;">
						<p><strong>'.$this->l('NOTE').'</strong></p>
						<p>'.$this->l('Missing email folders for languages​​:').' '.implode(', ', $missingMails).'</p>
						<p>'.$this->l('You need to create email templates for these languages, otherwise the customer will receive the email in English for these language.').'<br \>
						   '.$this->l('To create email templates in your language just go to "mails" folder of this module and make a copy of one of these folder (eg. can copy folder "en"), now rename this folder to the ISO Code of the language you need (can see the ISO Code of a language in your back office in lenguages​​) and translate the content of each email template.').'</p>
					</div>
					<div>&nbsp;</div>';
				}
				$this->_html .= '
				<div class="clear"></div>

				<label class="control-label">'.$this->l('Show popup on any page?').'</label>
				<div class="margin-form">

					<input type="radio" name="in_all_pages" value="1" onclick="hideSelectPages()" '.(Configuration::get('CTK_NP_IN_ALL_PAGES') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/enabled.gif" alt="'.$this->l('Yes').'" title="'.$this->l('Yes').'" />
					<input type="radio" name="in_all_pages" value="0" onclick="showSelectPages()" '.(!Configuration::get('CTK_NP_IN_ALL_PAGES') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/disabled.gif" alt="'.$this->l('No').'" title="'.$this->l('No').'" />

				</div>
				<div class="clear"></div>
				<div id="select_pages" style="display: none">
					<div class="clear"></div>
					<div class="margin-form">
						<select multiple="multiple" id="pages_to_show" name="pages_to_show[]">';
							foreach ($this->loadPages() as $pageKey => $pageName) {
								$select = false;
								if (isset($pagesSaved)) {
									foreach ($pagesSaved as $pageSaved)
										if ($pageKey == $pageSaved)
											$select = true;
								}
								$this->_html .= '<option value="'.$pageKey.'" '.($select ? 'selected="selected"' : '').'>'.$pageName.'</option>';
							}
							$this->_html .= '
						</select>
						<p>'.$this->l('Select which pages will show the popup.').'</p>
					</div>
				</div>
				<div class="clear"></div>
				<label>'.$this->l('Detect customers subscribed and don\'t show the popup?').'</label>
				<div class="margin-form">
					<input type="radio" name="detect_subs" value="1" '.(Configuration::get('CTK_NP_DETECT_SUBS') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/enabled.gif" alt="'.$this->l('Yes').'" title="'.$this->l('Yes').'" />
					<input type="radio" name="detect_subs" value="0" '.(!Configuration::get('CTK_NP_DETECT_SUBS') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/disabled.gif" alt="'.$this->l('No').'" title="'.$this->l('No').'" />
					<p>'.$this->l('In the case of a customer who is currently logged in and that is subscribed, the popup will not be published.').'</p>
				</div>
				<div class="clear"></div>
				<label>'.$this->l('How to show the newsletter popup?').'</label>
				<div class="margin-form">
					<select name="once_per_visit" >
						<option value="2"'.(Configuration::get('CTK_NP_ONCE_PER_VISIT') == 2 ? 'selected="selected"' : '').'>'.$this->l('Optional, do not show again').'</option>
						<option value="1"'.(Configuration::get('CTK_NP_ONCE_PER_VISIT') == 1 ? 'selected="selected"' : '').'>'.$this->l('First visit').'</option>
						<option value="0"'.(Configuration::get('CTK_NP_ONCE_PER_VISIT') == 0 ? 'selected="selected"' : '').'>'.$this->l('All time').'</option>
					</select>
				</div>
				<div class="clear"></div>
				<label>'.$this->l('How long to reset the preferences?').'</label>
				<div class="margin-form">
					<select name="cookie_time" >
						<option value="30"'.(Configuration::get('CTK_NP_COOKIE_DAYS') == 30 ? 'selected="selected"' : '').'>'.$this->l('30 days').'</option>
						<option value="15"'.(Configuration::get('CTK_NP_COOKIE_DAYS') == 15 ? 'selected="selected"' : '').'>'.$this->l('15 days').'</option>
						<option value="7"'.(Configuration::get('CTK_NP_COOKIE_DAYS') == 7 ? 'selected="selected"' : '').'>'.$this->l('7 days').'</option>
						<option value="1"'.(Configuration::get('CTK_NP_COOKIE_DAYS') == 1 ? 'selected="selected"' : '').'>'.$this->l('1 day').'</option>
						<option value="0"'.(!Configuration::get('CTK_NP_COOKIE_DAYS') ? 'selected="selected"' : '').'>'.$this->l('When close the browser').'</option>
					</select>
				</div>
				<div class="clear"></div>
				<label>'.$this->l('Send link verification e-mail after subscription?').'</label>
				<div class="margin-form">
					<input type="radio" name="verif_email" value="1" onclick="sendVerify()" '.(Configuration::get('CTK_NP_VERIFICATION_EMAIL') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/enabled.gif" alt="'.$this->l('Yes').'" title="'.$this->l('Yes').'" />
					<input type="radio" name="verif_email" value="0" onclick="sendNotVerify()" '.(!Configuration::get('CTK_NP_VERIFICATION_EMAIL') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/disabled.gif" alt="'.$this->l('No').'" title="'.$this->l('No').'" />
					<p>'.$this->l('The customer must validate your email address.').'</p>
				</div>
				<div class="clear"></div>
				<label>'.$this->l('Send confirmation e-mail after subscription?').'</label>
				<div class="margin-form">
					<input type="radio" name="conf_email" value="1" '.(Configuration::get('CTK_NP_CONFIRMATION_EMAIL') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/enabled.gif" alt="'.$this->l('Yes').'" title="'.$this->l('Yes').'" />
					<input type="radio" name="conf_email" value="0" '.(!Configuration::get('CTK_NP_CONFIRMATION_EMAIL') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/disabled.gif" alt="'.$this->l('No').'" title="'.$this->l('No').'" />
				</div>
				<div class="clear"></div>
				<label>'.$this->l('Send voucher code?').'</label>
				<div class="margin-form">
					<input type="radio" name="send_voucher" value="1" onclick="showVoucherForm()" '.(Configuration::get('CTK_NP_SEND_VOUCHER') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/enabled.gif" alt="'.$this->l('Yes').'" title="'.$this->l('Yes').'" />
					<input type="radio" name="send_voucher" value="0" onclick="hideVoucherForm()" '.(!Configuration::get('CTK_NP_SEND_VOUCHER') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/disabled.gif" alt="'.$this->l('No').'" title="'.$this->l('No').'" />
				</div>
				<div class="clear"></div>
				<div id="send_voucher_form" style="display: none; max-height: 100px; overflow: hidden;">
					<div class="clear"></div>
					<div class="margin-form">
						<input type="radio" name="voucher_type" value="1" onclick="showType1()" '.(Configuration::get('CTK_NP_VOUCHER_TYPE') == 1 ? 'checked="checked" ' : '').'/> <strong>'.$this->l('Code previously generated').'</strong><br />
						<input type="radio" name="voucher_type" value="2" onclick="showType2()" '.(Configuration::get('CTK_NP_VOUCHER_TYPE') == 2 ? 'checked="checked" ' : '').'/> <strong>'.$this->l('Generate automatic code for each subscriber').'</strong>
					</div>
					<div class="clear"></div>
					<div id="type1" style="display: none">
						<div class="clear"></div>
						<div class="margin-form">
							<input type="text" name="voucher" value="'.Configuration::get('CTK_NP_VOUCHER_CODE').'" />
							<p>'.$this->l('Enter the voucher code.').'</p>
						</div>
					</div>
					<div class="clear"></div>
					<div id="type2" style="display: none">
						<div class="clear"></div>
						<div class="margin-form" style="float: left; padding-right: 25px;">
							<input type="text" name="voucher_up_amount" value="'.Configuration::get('CTK_NP_VOUCHER_UP_AMOUNT').'" size="6" onKeyUp="javascript:this.value = this.value.replace(/,/g, \'.\');" /> %
							<p>'.$this->l('Discount amount.').'</p>
						</div>
						<div class="margin-form" style="padding-left: 15px;">
							<input type="text" name="voucher_up_days" value="'.Configuration::get('CTK_NP_VOUCHER_UP_DAYS').'" size="6" /> '.$this->l('day(s)').'
							<p>'.$this->l('Discount validity.').'</p>
						</div>
					</div>
				</div>
				<div class="clear"></div>
				<label>'.$this->l('Show accept the terms and conditions?').'</label>
				<div class="margin-form">
					<input type="radio" name="show_terms" value="1" onclick="showTermsOption()" '.(Configuration::get('CTK_NP_SHOW_TERMS') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/enabled.gif" alt="'.$this->l('Yes').'" title="'.$this->l('Yes').'" />
					<input type="radio" name="show_terms" value="0" onclick="hideTermsOption()" '.(!Configuration::get('CTK_NP_SHOW_TERMS') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/disabled.gif" alt="'.$this->l('No').'" title="'.$this->l('No').'" />
				</div>
				<div class="clear"></div>
				<div id="terms_option" style="display: none">
					<div class="clear"></div>
					<div class="margin-form">
						<select name="id_cms_terms">
							<option value="0">('.$this->l('Select a page').')</option>';
							foreach ($cmss as $cms)
								$this->_html .= '<option value="'.$cms['id_cms'].'"'.(Configuration::get('CTK_NP_ID_CMS_TERMS') == $cms['id_cms'] ? ' selected="selected"' : '').'>'.$cms['meta_title'].'</option>';
							$this->_html .= '
						</select>
						<p>'.$this->l('Select cms page of the terms.').'</p>
					</div>
				</div>
				<div class="clear"></div>
				<label>'.$this->l('Do you want to show an advertising block?').'</label>
				<div class="margin-form">
					<input type="radio" name="show_advertising" value="1" onclick="showAdvertisingBlock()" '.(Configuration::get('CTK_NP_SHOW_ADVERTISING') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/enabled.gif" alt="'.$this->l('Yes').'" title="'.$this->l('Yes').'" />
					<input type="radio" name="show_advertising" value="0" onclick="hideAdvertisingBlock()" '.(!Configuration::get('CTK_NP_SHOW_ADVERTISING') ? 'checked="checked" ' : '').'/>
					<img src="../img/admin/disabled.gif" alt="'.$this->l('No').'" title="'.$this->l('No').'" />
				</div>
				<div class="clear"></div>
				<div class="advertising_block" style="display: none">
					<div class="clear"></div>
					<div class="margin-form">
						<input type="checkbox" name="advertising_in_responsive" value="1" '.(Configuration::get('CTK_NP_ADVERTISING_IN_RESPONSIVE') ? 'checked="checked" ' : '').'/> <strong>'.$this->l('Show also in devices with responsive design.').'</strong><br />
					</div>
					<div class="clear"></div>
					<div class="margin-form">';
						foreach ($languages as $language) {
							$content = $this->_getContent($language['id_lang']);
							$this->_html.= '
							<div id="advertising_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
								<textarea class="rte" cols="50" rows="30" name="advertising_'.$language['id_lang'].'" id="advertisingInput_'.$language['id_lang'].'">'.$content['content'].'</textarea>
							</div>';
						}
						$this->_html.= $this->displayFlags($languages, $defaultLanguage, 'advertising', 'advertising', true);
						$this->_html .= '
						<div class="clear"></div>
					</div>
				</div>
				<div class="clear"></div>
				<label>'.$this->l('Set a delay to show').'</label>
				<div class="margin-form">
					<input type="text" name="delay_popup" value="'.Configuration::get('CTK_NP_DELAY_POPUP').'" size="6" /> '.$this->l('second(s)').'
				</div>
				<div class="clear"></div>
				<label>'.$this->l('Set Background Image').'</label>
				<div class="margin-form">
					<input type="file" name="background_image" value="" /> <br />
					<img style="width: 400px; height: auto;" src="../modules/'.$this->name.'/css/'.Configuration::get('CTK_NP_BACKGROUND_IMG').'" />
				</div>

			</fieldset>

			<div class="clear"></div>
			<div class="final_btns">
				<div class="margin-form clear pspace"><input type="submit" name="submitUpdate" value="'.$this->l('Update settings').'" class="button" /></div>
			</div>
		</form>';

		$isoTinyMCE = (file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en');
		$ad = dirname($_SERVER["PHP_SELF"]);
		$this->_html.= '<script type="text/javascript">
			var iso = \''.$isoTinyMCE.'\' ;
			var pathCSS = \''._THEME_CSS_DIR_.'\' ;
			var ad = \''.$ad.'\' ;
		</script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>';
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$this->_html.= '<script type="text/javascript">$(document).ready(function(){tinySetup();});</script>';

		return $this->_html;
	}

	private function _getContent($lang)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$this->context = Context::getContext();
			$id_shop = $this->context->shop->id;
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `content` FROM `'._DB_PREFIX_.'ctk_np_advertising` WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else
		{
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `content` FROM `'._DB_PREFIX_.'ctk_np_advertising` WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	private function _addContent()
	{
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$context = Context::getContext();
			$id_shop = $context->shop->id;
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$content = Tools::getValue('advertising_'.$language['id_lang']) ? Tools::getValue('advertising_'.$language['id_lang']) : Tools::getValue('advertising_'.$defaultLanguage);
				$query = 'REPLACE INTO `'._DB_PREFIX_.'ctk_np_advertising`
				VALUES ('.$language['id_lang'].', '.(int)$id_shop.', \''.addslashes($content).'\')';
				Db::getInstance()->execute($query);
			}
			return true;
		}
		else
		{
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$content = Tools::getValue('advertising_'.$language['id_lang']) ? Tools::getValue('advertising_'.$language['id_lang']) : Tools::getValue('advertising_'.$defaultLanguage);
				$query = 'REPLACE INTO `'._DB_PREFIX_.'ctk_np_advertising`
				VALUES ('.$language['id_lang'].', 1, \''.addslashes($content).'\')';
				Db::getInstance()->execute($query);
			}
			return true;
		}
		return true;
	}

	private function loadPages()
	{
		$pages = array('index' => $this->l('Home page'),
					'authentication' => $this->l('Authentication'),
					'password' => $this->l('Password recovery'),
					'my-account' => $this->l('My account'),
					'history' => $this->l('My account - History'),
					'order-slip' => $this->l('My account - Credit slips'),
					'addresses' => $this->l('My account - Addresses'),
					'identity' => $this->l('My account - Personal information'),
					'discount' => $this->l('My account - Vouchers'),
					'sitemap' => $this->l('Sitemap'),
					'search' => $this->l('Search page'),
					'order' => $this->l('Shopping cart'),
					'new-products' => $this->l('New products'),
					'best-sales' => $this->l('Best sales'),
					'prices-drop' => $this->l('Price drop'),
					'manufacturer' => $this->l('Manufacturers'),
					'supplier' => $this->l('Suppliers'),
					'category' => $this->l('Categories'),
					'product' => $this->l('Products'),
					'products-comparison' => $this->l('Products comparison'),
					'cms' => $this->l('CMS pages'),
					'stores' => $this->l('Our stores'),
					'404' => $this->l('Error 404'),
				);

		if (_PS_VERSION_ >= '1.5')
			$pages['contact'] = $this->l('Contact form');
		else
			$pages['contact-form'] = $this->l('Contact form');

		return $pages;
	}

 	public function subscribeNewsletter($terms, $email)
 	{
		if (!$email)
			return array('msg' => $this->l('Please enter your email address.'), 'err' => 1);
		elseif (($id_cms = Configuration::get('CTK_NP_ID_CMS_TERMS')) AND Configuration::get('CTK_NP_SHOW_TERMS') AND !$terms)
			return array('msg' => $this->l('You need to accept the terms and conditions.'), 'err' => 1);
		else
		{
			$this->newsletterRegistration($email);
			if ($this->error)
				return array('msg' => $this->error, 'err' => 1);
			elseif ($this->valid)
				return array('msg' => $this->valid, 'err' => 0);
			else
				return array('msg' => $this->l('Unknown error.'), 'err' => 1);
		}
 	}

 	private function newsletterRegistration($email)
 	{
 	 	$registerStatus = $this->isNewsletterRegistered($email);

	 	if (empty($email) OR !Validate::isEmail($email))
			return $this->error = $this->l('Invalid e-mail address, please check.');

	 	//*** Subscription ***
	 	else
	 	{
			if ($registerStatus > 0)
			{
				if ($registerStatus == 3)
				{
					if (!$token = $this->getToken($email, $registerStatus))
						return $this->error = $this->l('Internal error during subscription.');

					return $this->error = $this->l('E-mail not been verified yet, please validate it by clicking the link sent by email.');
				}
				else
					return $this->error = $this->l('E-mail address already registered.');
			}

			//* If the user ins't a customer *
			elseif ($registerStatus == -1)
			{
				global $cookie;
				//* If subscription verification email is activate *
				if (Configuration::get('CTK_NP_VERIFICATION_EMAIL'))
				{
					//* create an unactive entry in the newsletter database *
					if (!Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'newsletter` (email, newsletter_date_add, ip_registration_newsletter, http_referer, active)
							VALUES (\''.$email.'\', NOW(), \''.Tools::getRemoteAddr().'\', (SELECT c.http_referer FROM `'._DB_PREFIX_.'connections` c WHERE c.id_guest = '.(int)($cookie->id_guest).' ORDER BY c.date_add DESC LIMIT 1), 0)'))
						return $this->error = $this->l('Internal error (01) during subscription, try later.');

					if (!$token = $this->getToken($email, $registerStatus))
						return $this->error = $this->l('Internal error (02) during subscription.');

					$this->sendVerificationEmailSubscription($email, $registerStatus, $token);
					return $this->valid = $this->l('A verification email to subscribe has been sent. Please check your email.');
				}
				else
				{
					if (!Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'newsletter` (email, newsletter_date_add, ip_registration_newsletter, http_referer, active)
							VALUES (\''.$email.'\', NOW(), \''.Tools::getRemoteAddr().'\', (SELECT c.http_referer FROM `'._DB_PREFIX_.'connections` c WHERE c.id_guest = '.(int)($cookie->id_guest).' ORDER BY c.date_add DESC LIMIT 1), 1)'))
						return $this->error = $this->l('Internal error (03) during subscription, try later.');

					if (!$this->sendConfirmationEmail($email) AND !$this->sendVoucher($email))
						return $this->valid = $this->l('Success!');
				}
			}

			//* If the user is a customer *
			elseif ($registerStatus == 0)
			{
			 	if (!Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'customer` SET `newsletter` = 1, newsletter_date_add = NOW(), `ip_registration_newsletter` = \''.Tools::getRemoteAddr().'\' WHERE `email` = \''.$email.'\''))
	 	 			return $this->error = $this->l('Internal error (04) during subscription, try later.');

				if (!$this->sendConfirmationEmail($email) AND !$this->sendVoucher($email))
					return $this->valid = $this->l('Success!');
			}
		}
 	}

 	private function isNewsletterRegistered($customerEmail)
 	{
 	 	if (Db::getInstance()->getRow('SELECT `email` FROM `'._DB_PREFIX_.'newsletter` WHERE `email` = \''.$customerEmail.'\''))
		{
			if (Configuration::get('CTK_NP_VERIFICATION_EMAIL'))
			{
				if (Db::getInstance()->getRow('SELECT `email` FROM `'._DB_PREFIX_.'newsletter` WHERE `email` = \''.$customerEmail.'\' AND `active` = \'0\''))
					return 3;
			}
 	 		return 1;
		}
		if (!$registered = Db::getInstance()->getRow('SELECT `newsletter` FROM `'._DB_PREFIX_.'customer` WHERE `email` = \''.$customerEmail.'\''))
			return -1;
		if ($registered['newsletter'] == '1')
			return 2;
		return 0;
 	}

	public function activateGuest($email)
	{
		return Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.'newsletter`
						SET `active` = 1
						WHERE `email` = \''.$email.'\''
				);
	}

	protected function getGuestEmail($token)
	{
		$sql = 'SELECT `email`
				FROM `'._DB_PREFIX_.'newsletter`
				WHERE MD5(CONCAT( `email` , `newsletter_date_add`, \''._COOKIE_KEY_.'\')) = \''.$token.'\'
				AND `active` = 0';

		return Db::getInstance()->getValue($sql);
	}

	private function getToken($email, $registerStatus)
	{
		/* Unsubscribe if the user ins't a customer */
		if ($registerStatus == 1)
		{
			$sql = 'SELECT MD5(CONCAT( `email` , `newsletter_date_add` , \''._COOKIE_KEY_.'\' )) as token
					FROM `'._DB_PREFIX_.'newsletter`
					WHERE `email` = \''.$email.'\'';
		}

		/* Unsubscribe if the user is a customer */
		elseif ($registerStatus == 2)
		{
			$sql = 'SELECT MD5(CONCAT( `email` , `date_add` , \''._COOKIE_KEY_.'\' )) as token
					FROM `'._DB_PREFIX_.'customer`
					WHERE `email` = \''.$email.'\'';
		}

		/* Subscribe ii the user is a customer or not */
		else
		{
			$sql = 'SELECT MD5(CONCAT( `email` , `newsletter_date_add` , \''._COOKIE_KEY_.'\' )) as token
					FROM `'._DB_PREFIX_.'newsletter`
					WHERE `email` = \''.$email.'\'';
		}

		return Db::getInstance()->getValue($sql);
	}

	public function confirmEmail($email, $token)
	{
		global $cookie;
		if (!$email OR !$token)
			return array('msg' => $this->l('Invalid activation link.'), 'err' => 1);

		$activated = false;

		if ($this->getGuestEmail($token))
			$activated = $this->activateGuest($email);

		if (!$activated)
			return array('msg' => $this->l('This email is already registered and/or link invalid.'), 'err' => 1);

		$this->sendConfirmationEmail($email);
		$this->sendVoucher($email);

		if ($this->error)
			return array('msg' => $this->error, 'err' => 1);
		elseif ($this->valid)
			return array('msg' => $this->valid, 'err' => 0);
		else
			return array('msg' => $this->l('Unknown error.'), 'err' => 1);
	}

	private function sendVerificationEmailSubscription($email, $registerStatus, $token)
	{
		global $cookie;
		if (Configuration::get('CTK_NP_VERIFICATION_EMAIL'))
		{
			if (($registerStatus == -1) OR ($registerStatus == 3))
			{
				if (_PS_VERSION_ >= '1.5')
					$verif_url = Context::getContext()->link->getModuleLink($this->name, 'verification', array('subs_newsletter_email' => $email, 'token' => $token));
				else
					$verif_url = Tools::getHttpHost(true).$this->_path.'verification.php?subs_newsletter_email='.$email.'&token='.$token;
				if (!Mail::Send($this->mailLang(), 'newsletter_verif', Mail::l('Email verification', (int)$cookie->id_lang), array('{verif_url}' => $verif_url), $email, NULL, NULL, NULL, NULL, NULL, dirname(__FILE__).'/mails/'))
					return $this->error = $this->l('Error sending email verification to subscribe.');
			}
		}
	}

	private function sendConfirmationEmail($email)
	{
		global $cookie;
		if (Configuration::get('CTK_NP_CONFIRMATION_EMAIL'))
		{
			if (!Mail::Send($this->mailLang(), 'newsletter_conf', Mail::l('Newsletter confirmation', (int)$cookie->id_lang), array(), $email, NULL, NULL, NULL, NULL, NULL, dirname(__FILE__).'/mails/'))
				return $this->error = $this->l('Subscription to the newsletter successful, but we had an error when sending email confirmation.');
			return $this->valid = $this->l('Success!');
		}
		return false;
	}

	private function sendVoucher($email)
	{
		global $cookie;
		if (Configuration::get('CTK_NP_SEND_VOUCHER'))
		{
			if (Configuration::get('CTK_NP_VOUCHER_TYPE') == 1)
			{
				if ($discount = Configuration::get('CTK_NP_VOUCHER_CODE'))
				{
					if (!Mail::Send($this->mailLang(), 'newsletter_voucher', Mail::l('Newsletter voucher', (int)$cookie->id_lang), array('{discount}' => $discount), $email, NULL, NULL, NULL, NULL, NULL, dirname(__FILE__).'/mails/'))
						return $this->error = $this->l('Subscription successful, but we had an error when sending email with voucher code, please contact us for your gift.');
					return $this->valid = $this->l('Success! An email was sent with your voucher code.');
				}
			}
			elseif (Configuration::get('CTK_NP_VOUCHER_TYPE') == 2)
			{
				if ($amount = Configuration::get('CTK_NP_VOUCHER_UP_AMOUNT') AND $days = Configuration::get('CTK_NP_VOUCHER_UP_DAYS'))
				{
					$voucher = $this->createDiscount(2, (float)$amount, null, strftime('%Y-%m-%d %H:%M:%S', strtotime('+'.(int)$days.' day')), $this->l('Thank you for you subscription our newsletter.'));
					if ($voucher !== false)
					{
						$templateVars = array('{email}' => $email, '{amount}' => $amount, '{days}' => $days, '{voucher_num}' => (_PS_VERSION_ >= '1.5' ? $voucher->code : $voucher->name));
						if (!Mail::Send($this->mailLang(), 'newsletter_voucher_2', Mail::l('Newsletter voucher', (int)$cookie->id_lang), $templateVars, $email, NULL, NULL, NULL, NULL, NULL, dirname(__FILE__).'/mails/'))
							return $this->error = $this->l('Subscription successful, but we had an error when sending email with voucher code, please contact us for your gift.');
						return $this->valid = $this->l('Success! An email was sent with your voucher code.');
					}
				}
			}
		}
		return false;
	}

	private function createDiscount($id_email_type, $amount, $id_customer = null, $dateValidity, $description)
	{
		if (_PS_VERSION_ >= '1.5') {
			$cartRule = new CartRule();
			$cartRule->reduction_percent = (float)$amount;
			$cartRule->date_to = $dateValidity;
			$cartRule->date_from = date('Y-m-d H:i:s');
			$cartRule->quantity = 1;
			$cartRule->quantity_per_user = 1;
			$cartRule->cart_rule_restriction = 1;
			$cartRule->minimum_amount = 0;

			$languages = Language::getLanguages(true);
			foreach ($languages AS $language)
				$cartRule->name[(int)$language['id_lang']] = $description;

			$code = 'CTKNP-'.strtoupper(Tools::passwdGen(10));
			$cartRule->code = $code;
			$cartRule->active = 1;
			if (!$cartRule->add())
				return false;
			return $cartRule;
		}
		else
		{
			$discount = new Discount();
			$discount->id_discount_type = 1;
			$discount->value = (float)($amount);
			$discount->date_to = $dateValidity;
			$discount->date_from = date('Y-m-d H:i:s');
			$discount->quantity = 1;
			$discount->quantity_per_user = 1;
			$discount->cumulable = 0;
			$discount->cumulable_reduction = 1;
			$discount->minimal = 0;

			$languages = Language::getLanguages(true);
			foreach ($languages AS $language)
				$discount->description[(int)($language['id_lang'])] = $description;

			$name = 'CTKNP-'.strtoupper(Tools::passwdGen(10));
			$discount->name = $name;
			$discount->active = 1;
			$result = $discount->add();

			if (!$result)
				return false;
			return $discount;
		}

	}

	public function setDisMiss()
	{
		$this->setCookie('ctk_np_cookie_2', 1);
		return;
	}

	private function loadVars()
	{
		return array(
			'CTK_NP_IN_ALL_PAGES' => '1',
			'CTK_NP_PAGES_TO_SHOW' => '',
			'CTK_NP_DETECT_SUBS' => '0',
			'CTK_NP_ONCE_PER_VISIT' => '2',
			'CTK_NP_COOKIE_DAYS' => '0',
			'CTK_NP_VERIFICATION_EMAIL' => '0',
			'CTK_NP_CONFIRMATION_EMAIL' => '0',
			'CTK_NP_SEND_VOUCHER' => '0',
			'CTK_NP_VOUCHER_TYPE' => '',
			'CTK_NP_VOUCHER_CODE' => '',
			'CTK_NP_VOUCHER_UP_AMOUNT' => '',
			'CTK_NP_VOUCHER_UP_DAYS' => '',
			'CTK_NP_SHOW_TERMS' => '0',
			'CTK_NP_SHOW_ADVERTISING' => '0',
			'CTK_NP_ADVERTISING_IN_RESPONSIVE' => '1',
			'CTK_NP_ID_CMS_TERMS' => '0',
			'CTK_NP_OPT_RDESIGN' => '0',
			'CTK_NP_OPT_OLD_PS' => '0',
			'CTK_NP_DELAY_POPUP' => '1',
		);
	}

	private function detectSubscription()
	{
		if (!Configuration::get('CTK_NP_DETECT_SUBS'))
			return true;
		else {
			global $cookie;
			if (!isset($cookie->email) OR $this->isNewsletterRegistered($cookie->email) <= 0)
				return true;
			else
				return false;
		}
	}

	private function detectPage()
	{
		if (Configuration::get('CTK_NP_IN_ALL_PAGES'))
			return true;
		else {
				if (!$pages = explode(',', Configuration::get('CTK_NP_PAGES_TO_SHOW')))
					return false;
				else {
					if (_PS_VERSION_ >= '1.5') {
						if (isset(Context::getContext()->controller->php_self))
							$currentPage = Context::getContext()->controller->php_self;
						else
							$currentPage = Dispatcher::getInstance()->getController();
					}
					else
						$currentPage = basename($_SERVER['PHP_SELF'], '.php');//(substr($_SERVER['PHP_SELF'], strlen(__PS_BASE_URI__)));

					$show = false;
					foreach ($pages as $page)
						if ($page == $currentPage)
							$show = true;

					return $show;
				}
		}
	}

	private function header_15()
	{
		if (Configuration::get('CTK_NP_OPT_RDESIGN')) {
			require_once(_PS_TOOL_DIR_.'mobile_Detect/Mobile_Detect.php');
			$this->mobile_detect = new Mobile_Detect();
			$this->context->controller->addCSS(($this->_path).'css/bakednewsletter'.($this->mobile_detect->isMobile() ? '.mobile' : '').'.css', 'all');
			if (Configuration::get('CTK_NP_SHOW_ADVERTISING') AND Configuration::get('CTK_NP_ADVERTISING_IN_RESPONSIVE'))
				$this->smarty->assign('ctk_vscl_advertising', $this->_getContent((int)$this->context->language->id));
		}
		else {
			$this->context->controller->addCSS(($this->_path).'css/bakednewsletter.css', 'all');
			if (Configuration::get('CTK_NP_SHOW_ADVERTISING'))
				$this->smarty->assign('ctk_vscl_advertising', $this->_getContent((int)$this->context->language->id));
		}
		$this->context->controller->addJS(array(
			($this->_path).'js/'.$this->CTKSript(), 'all',
			($this->_path).'js/jquery.reveal.min.js', 'all')
		);

		if (($id_cms = Configuration::get('CTK_NP_ID_CMS_TERMS')) AND Configuration::get('CTK_NP_SHOW_TERMS'))
		{
			$this->context->controller->addJS(array(
				($this->_path).'js/jquery.jscrollpane.min.js', 'all',
				($this->_path).'js/jquery.mousewheel.js', 'all')
			);
			$this->smarty->assign('ctk_id_terms', $id_cms);
			$this->smarty->assign('ctk_terms', CMS::getCMSPages((int)$this->context->language->id));
		}
		$this->smarty->assign('ctk_nt_voucher', $this->CheckVoucher());

		return;
	}

	private function header_14()
	{
		global $cookie, $smarty;

		Tools::addCSS(($this->_path).'css/bakednewsletter.css', 'all');
		Tools::addJS(array(
//			($this->_path).'js/jquery-1.7.2.min.js', 'all',
			($this->_path).'js/'.$this->CTKSript(), 'all',
			($this->_path).'js/jquery.reveal.min.js', 'all')
		);

		if (($id_cms = Configuration::get('CTK_NP_ID_CMS_TERMS')) AND Configuration::get('CTK_NP_SHOW_TERMS'))
		{
			Tools::addJS(array(
				($this->_path).'js/jquery.jscrollpane.min.js', 'all',
				($this->_path).'js/jquery.mousewheel.js', 'all')
			);
			$smarty->assign('ctk_id_terms', $id_cms);
			$smarty->assign('ctk_terms', CMS::getCMSPages((int)$cookie->id_lang));
		}
		if (Configuration::get('CTK_NP_SHOW_ADVERTISING'))
			$smarty->assign('ctk_vscl_advertising', $this->_getContent((int)($cookie->id_lang)));
		$smarty->assign('ctk_nt_voucher', $this->CheckVoucher());

		return;
	}

	public function hookHeader()
	{
		global $cookie, $smarty;
		$show_popup = 0;

		if (Configuration::get('CTK_NP_ONCE_PER_VISIT') == 1) {
			if(!$this->getCookie('ctk_np_cookie_1')) {
				$this->setCookie('ctk_np_cookie_1', 1);
				$show_popup = 1;
			}
		}
		elseif (Configuration::get('CTK_NP_ONCE_PER_VISIT') == 2) {
			if(!$this->getCookie('ctk_np_cookie_2')) {
				$smarty->assign('ctk_dismiss', true);
				$show_popup = 1;
			}
		}
		else
			$show_popup = 1;

		if ($show_popup) {
			if ($this->detectSubscription()) {
				if ($this->detectPage()) {
					if (_PS_VERSION_ >= '1.5')
						$this->header_15();
					else
						$this->header_14();

					$smarty->assign('ctk_np_delay', (Configuration::get('CTK_NP_DELAY_POPUP')*1000));
					return $this->display(__FILE__, 'bakednewsletter.tpl');
				}
			}
		}
	}
	
	public function hookDisplayTop()
	{
		global $cookie, $smarty;
		$show_popup = 0;

		if (Configuration::get('CTK_NP_ONCE_PER_VISIT') == 1) {
			if(!$this->getCookie('ctk_np_cookie_1')) {
				$this->setCookie('ctk_np_cookie_1', 1);
				$show_popup = 1;
			}
		}
		elseif (Configuration::get('CTK_NP_ONCE_PER_VISIT') == 2) {
			if(!$this->getCookie('ctk_np_cookie_2')) {
				$smarty->assign('ctk_dismiss', true);
				$show_popup = 1;
			}
		}
		else
			$show_popup = 1;

		if ($show_popup) {
			if ($this->detectSubscription()) {
				if ($this->detectPage()) {
					if (_PS_VERSION_ >= '1.5')
						$this->header_15();
					else
						$this->header_14();

					$smarty->assign('ctk_np_delay', (Configuration::get('CTK_NP_DELAY_POPUP')*1000));
					return $this->display(__FILE__, 'bakednewsletter.tpl');
				}
			}
		}
	}

	public function hookDisplayMobileHeader()
	{
		$show_popup = 0;

		if (Configuration::get('CTK_NP_ONCE_PER_VISIT') == 1) {
			if(!$this->getCookie('ctk_np_cookie_1')) {
				$this->setCookie('ctk_np_cookie_1', 1);
				$show_popup = 1;
			}
		}
		elseif (Configuration::get('CTK_NP_ONCE_PER_VISIT') == 2) {
			if(!$this->getCookie('ctk_np_cookie_2')) {
				$this->smarty->assign('ctk_dismiss', true);
				$show_popup = 1;
			}
		}
		else
			$show_popup = 1;

		if ($show_popup) {
			if ($this->detectSubscription()) {
				if ($this->detectPage()) {
					$this->context->controller->addCSS(($this->_path).'css/bakednewsletter.mobile.css', 'all');
					$this->context->controller->addJS(array(
						($this->_path).'js/'.$this->CTKSript(), 'all',
						($this->_path).'js/jquery.reveal.min.js', 'all')
					);
					$this->smarty->assign('ctk_nt_voucher', $this->CheckVoucher());
					if (($id_cms = Configuration::get('CTK_NP_ID_CMS_TERMS')) AND Configuration::get('CTK_NP_SHOW_TERMS')) {
						$this->smarty->assign('ctk_id_terms', $id_cms);
						$this->smarty->assign('ctk_terms', CMS::getCMSPages((int)$this->context->language->id));
					}
					if (Configuration::get('CTK_NP_SHOW_ADVERTISING') AND Configuration::get('CTK_NP_ADVERTISING_IN_RESPONSIVE'))
						$this->smarty->assign('ctk_vscl_advertising', $this->_getContent((int)$this->context->language->id));
					$this->smarty->assign('ctk_np_delay', (Configuration::get('CTK_NP_DELAY_POPUP')*1000));
					return $this->display(__FILE__, 'bakednewsletter.tpl');
				}
			}
		}
	}

    private function setCookie($name, $value = null, $expire = null)
    {
		if (!Configuration::get('CTK_NP_COOKIE_DAYS'))
			$expTime = 0;
		else
			$expTime = time()+60*60*24*(!Configuration::get('CTK_NP_COOKIE_DAYS') ? 30 : Configuration::get('CTK_NP_COOKIE_DAYS')); // Defaul expire on 30 days

		if (PHP_VERSION_ID <= 50200) /* PHP version > 5.2.0 */
			$set = setcookie($name, $value, ($expire ? $expire : $expTime), $this->ckPath, $this->ckDomain, 0);
		else
			$set = setcookie($name, $value, ($expire ? $expire : $expTime), $this->ckPath, $this->ckDomain, 0, true);

        return $set;
    }

    private function getCookie($name)
    {
        if (isset($_COOKIE[$name]) /*&& is_array($_COOKIE) && array_key_exists($name, $_COOKIE)*/)
        {
            return $_COOKIE[$name];
        }
        return false;
    }

    private function unsetCookie($name, $value = '')
    {
        if ($this->getCookie($name) != false)
        {
			if (PHP_VERSION_ID <= 50200) /* PHP version > 5.2.0 */
				setcookie($name, $value, time() - 3600, $this->ckPath, $this->ckDomain, 0);
			else
				setcookie($name, $value, time() - 3600, $this->ckPath, $this->ckDomain, 0, true);

            return true;
        }
        return false;
    }

	protected function getDomain($shared_urls = null)
	{
		$r = '!(?:(\w+)://)?(?:(\w+)\:(\w+)@)?([^/:]+)?(?:\:(\d*))?([^#?]+)?(?:\?([^#]+))?(?:#(.+$))?!i';

		if (!preg_match ($r, Tools::getHttpHost(false, false), $out) || !isset($out[4]))
			return false;

		if (preg_match('/^(((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]{1}[0-9]|[1-9]).)'.
			'{1}((25[0-5]|2[0-4][0-9]|[1]{1}[0-9]{2}|[1-9]{1}[0-9]|[0-9]).)'.
			'{2}((25[0-5]|2[0-4][0-9]|[1]{1}[0-9]{2}|[1-9]{1}[0-9]|[0-9]){1}))$/', $out[4]))
			return false;
		if (!strstr(Tools::getHttpHost(false, false), '.'))
			return false;

		$domain = false;
		if ($shared_urls !== null)
		{
			foreach ($shared_urls as $shared_url)
			{
				if ($shared_url != $out[4])
					continue;
				if (preg_match('/^(?:.*\.)?([^.]*(?:.{2,4})?\..{2,3})$/Ui', $shared_url, $res))
				{
					$domain = '.'.$res[1];
					break;
				}
			}
		}
		if (!$domain)
			$domain = $out[4];
		return $domain;
	}

	private function CheckVoucher()
	{
		if (Configuration::get('CTK_NP_SEND_VOUCHER')) {
			if (Configuration::get('CTK_NP_VOUCHER_TYPE') == 1) {
				if (Configuration::get('CTK_NP_VOUCHER_CODE'))
					return true;
			}
			elseif (Configuration::get('CTK_NP_VOUCHER_TYPE') == 2) {
				if (Configuration::get('CTK_NP_VOUCHER_UP_AMOUNT') AND Configuration::get('CTK_NP_VOUCHER_UP_DAYS'))
					return true;
			}
		}
		return false;
	}

	private function mailLang()
	{
		global $cookie;

		$iso = Language::getIsoById((int)$cookie->id_lang);
		if (!file_exists($this->base.'/mails/'.$iso))
			return (_PS_VERSION_ >= '1.5' ? 3 : 1);
		else
			return (int)$cookie->id_lang;
	}

	private function CTKSript()
	{
		if (Configuration::get('CTK_NP_OPT_OLD_PS'))
			return 'bakednewsletter_14.min.js';
		else
			return 'bakednewsletter_15.js';
	}

	private function _installDB()
	{
		if (_PS_VERSION_ >= '1.5') {
			$en = 3;
			$fr = 4;
			$es = 1;
		}
		else {
			$en = 1;
			$fr = 2;
			$es = 3;
		}
		$url = Tools::getHttpHost(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/images/';
		$sql = array();

		$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'ctk_np_advertising` (
					  `id_lang` int(10) NOT NULL,
					  `id_shop` int(10) unsigned NULL,
					  `content` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
					  PRIMARY KEY (`id_lang`)
				) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';

		$sql[] = 'INSERT INTO `'._DB_PREFIX_.'ctk_np_advertising` (`id_lang`, `id_shop`, `content`) VALUES
					('.$en.', 1, \'<img style="display: block; margin: 0;" src="'.$url.'pop_up_footer.png" alt="" width="476" height="auto" />\');';

		return $sql;
	}

	private function saveLog($msg)
	{
		$file = $this->base."/error_log.txt";
		$date = date("Y-m-d H:i:s");
		$msg = "\n".$date." - ".$msg;
		@file_put_contents($file, $msg, FILE_APPEND | LOCK_EX);
		return;
	}
}
