<?php
/**
 * Baked Look Book module
 *
 * @author    Baked Themes
 * @copyright Baked Themes
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

include_once dirname(__FILE__).'/../../BakedLookBookClass.php';
include_once dirname(__FILE__).'/../../BakedLookBookGroup.php';
class BakedLookBookDetailModuleFrontController extends ModuleFrontController
{
	public function initContent()
	{
		parent::initContent();
		$id_look_book_group = (int)Tools::getValue('id_look_book_group');
		$id_lang	  = $this->context->language->id;
		$id_shop	  = $this->context->shop->id;
		$bake_look_book = new BakedLookBookClass();
		$look_book_group = new BakedLookBookGroup($id_look_book_group);
		$look_books		= $bake_look_book->getLookBooksByGroup($id_look_book_group, $id_lang);
		if (empty($look_books))
			return;
		foreach ($look_books as &$look_book)
			$look_book['coordinates'] = $bake_look_book->getCoordinates($look_book['id_baked_look_book'], $id_lang, $id_shop);
		$this->context->smarty->assign(array(
				'look_books' => $look_books,
				'look_book_group' => $look_book_group,
				'img_path'	 => _PS_BASE_URL_,
				'id_look_book_group' => $id_look_book_group
			));

		$this->setTemplate('look_book_detail.tpl');
	}

}
