<?php
/**
 * Baked Look Book module
 *
 * @author    Baked Themes
 * @copyright Baked Themes
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

class BakedLookBookGroup extends ObjectModel
{
	/** @var integer*/
	public $id;
	/** @var string*/
	public $name;
	/** @var integer */
	public $image;
	/** @var integer */
	public $active;

	/**
	 * @see ObjectModel::$definition
	 */
	public static $definition = array(
		'table'		 => 'baked_look_book_group',
		'primary'	 => 'id_baked_look_book_group',
		'fields'	 => array(
			'name'	 => array( 'type'		 => self::TYPE_STRING, 'size'		 => 255, 'validate'	 => 'isGenericName', 'required'	 => true ),
			'image'	 => array( 'type'		 => self::TYPE_STRING, 'size'		 => 255, 'validate'	 => 'isGenericName' ),
			'active' => array( 'type'		 => self::TYPE_BOOL, 'validate'	 => 'isBool' )
		),
	);

	public static function getAll($active = 0)
	{
		Shop::addTableAssociation('baked_look_book_group', array( 'type' => 'shop' ));
		return Db::getInstance()->executeS('SELECT blbg.*
			FROM `'._DB_PREFIX_.'baked_look_book_group` blbg
			'.Shop::addSqlAssociation('baked_look_book_group', 'blbg').
						(($active) ? 'WHERE blbg.`active`=1' : '')
		);
	}

	public function delete()
	{
		$multi = Db::getInstance()->getValue('
			SELECT count(0)
			FROM `'._DB_PREFIX_.'baked_look_book_group_shop`
			WHERE id_baked_look_book_group='.$this->id
		);
		if ($multi > 1)
		{
			return Db::getInstance()->execute('
    			DELETE
    			FROM `'._DB_PREFIX_.'baked_look_book_group_shop`
    			WHERE id_baked_look_book_group='.$this->id.Shop::addSqlRestrictionOnLang()
			);
		}
		else
		{
			$slides	 = Db::getInstance()->executeS('
    			SELECT id_baked_look_book
    			FROM `'._DB_PREFIX_.'baked_look_book`
    			WHERE id_baked_look_book_group='.$this->id
			);
			$res	 = true;
			foreach ($slides as $v)
			{
				$slide = new BakedLookBookClass($v['id_baked_look_book']);
				if ($slide)
					$res &= $slide->delete();
			}
			$res &= parent::delete();
			return $res;
		}
	}

	public static function categoryHasSlide($identify)
	{
		return Db::getInstance()->getValue('
			SELECT count(0)
			FROM `'._DB_PREFIX_.'baked_look_book_group_shop` blbgs
			'.Shop::addSqlAssociation('baked_look_book_group_shop', 'blbgs').'
			WHERE blbgs.`active`=1 '.( is_array($identify) ? ' and blbgs.`id_category` IN ('.implode(',', $identify).') ' : ' and blbgs.`id_category` = '.(int)$identify )
		);
	}

	public static function getSlideGroup($identify, $type = 1)
	{
		$identify	 = (array)$identify;
		Shop::addTableAssociation('baked_look_book_group_shop', array( 'type' => 'shop' ));
		$where		 = '';
		if ($type == 1)
			$where .= ' AND blbgs.`location` IN ('.implode(',', $identify).')';
		elseif ($type == 2)
		{
			if (self::categoryHasSlide($identify))
				$where .= ' AND blbgs.`id_category` IN ('.implode(',', $identify).')';
			else
			{
				$id_has = 0;
				foreach ($identify as $id_category)
				{
					if ($id_has)
						break;
					$category	 = new Category($id_category);
					$parents	 = $category->getParentsCategories();

					foreach ($parents as $parent)
					{
						if (self::categoryHasSlide($parent['id_category']))
						{
							$id_has = $parent['id_category'];
							break;
						}
					}
				}
				if ($id_has)
					$where .= ' AND blbgs.`id_category` = '.$id_has;
			}
		}
		elseif ($type == 3)
			$where .= ' AND blbgs.`id_baked_look_book_group` IN ('.implode(',', $identify).')';

		if (!$where)
			return false;
		return Db::getInstance()->executeS('
			SELECT blbgs.*
			FROM `'._DB_PREFIX_.'baked_look_book_group_shop` blbgs
			'.Shop::addSqlAssociation('baked_look_book_group_shop', 'blbgs').'
			WHERE blbgs.`active`=1 '.$where.'
            ORDER BY blbgs.`position`');
	}
}