<?php

class NewProductsController extends NewProductsControllerCore
{
	public function initContent()
	{
		parent::initContent();

		$this->productSort();

		$nbProducts = (int)Product::getNewProducts(
						$this->context->language->id, (isset($this->p) ? (int)($this->p) - 1 : null), (isset($this->n) ? (int)($this->n) : null), true
		);

		$this->pagination($nbProducts);

		$new_prod	 = Product::getNewProducts($this->context->language->id, (int)($this->p) - 1, (int)($this->n), false, $this->orderBy, $this->orderWay);
		/*		 * *********************** /Images Array ***************************** */
		$image_array = array( );
		for ($i = 0; $i < $nbProducts; $i++)
		{
			if (isset($new_prod[$i]['id_product']))
				$image_array[$new_prod[$i]['id_product']] = Product::getHoverProductsImgs($new_prod[$i]['id_product']);
		}
		$this->context->smarty->assign('bakedimages', (isset($image_array) AND $image_array) ? $image_array : NULL);

		/*		 * *********************** /Images Array ***************************** */

		$this->context->smarty->assign(array(
			'products'			 => $new_prod,
			'add_prod_display'	 => Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),
			'nbProducts'		 => (int)($nbProducts),
			'homeSize'			 => Image::getSize('home')
		));

		$this->setTemplate(_PS_THEME_DIR_.'new-products.tpl');
	}

}