{**
* Multi Accessories
*
* @author    Hamsa
* @copyright Hamsa
* @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*}
{if $input.type=='input'}
<div class="margin-form">
	{foreach $languages as $language}
		{assign var='value_text' value=$input.value[$language.id_lang]}
		<div class="translatable-field lang-{$language.id_lang}" {if $language.id_lang != $default_language}style="display:none"{/if}>
			<div class="col-lg-4">
				<input style="width: 100px;" type="text"
					   id="{if isset($input.id)}{$input.id}_{$language.id_lang|escape:'string':'UTF-8'}{else}{$input.name|escape:'string':'UTF-8'}_{$language.id_lang|escape:'string':'UTF-8'}{/if}"
					   name="{$input.name|escape:'string':'UTF-8'}_{$language.id_lang|escape:'string':'UTF-8'}"
					   class="{if isset($input.class)}{$input.class|escape:'string':'UTF-8'}{/if}"
					   value="{$value_text|escape:'string':'UTF-8'}"
					   onkeyup="if (isArrowKey(event))
									   return;
							   updateFriendlyURL();"/>
			</div>
			{if $languages|count > 1}
				<div class="col-lg-2">
					<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
						{$language.iso_code|escape:'string':'UTF-8'}
						<i class="icon-caret-down"></i>
					</button>
					<ul class="dropdown-menu">
						{foreach from=$languages item=language}
							<li><a href="javascript:hideOtherLanguage({$language.id_lang|escape:'string':'UTF-8'});" tabindex="-1">{$language.name|escape:'string':'UTF-8'}</a></li>
							{/foreach}
					</ul>
				</div>
			{/if}
		</div>
	{/foreach}
</div>
{elseif $input.type='textarea'}
	{assign var=use_textarea_autosize value=true}
		{foreach $languages as $language}
			{if $languages|count > 1}
				<div class="form-group translatable-field lang-{$language.id_lang}"  {if $language.id_lang != $default_language}style="display:none;"{/if}>

					<div class="col-lg-9">
					{/if}
					<textarea name="{$input.name}_{$language.id_lang}" class="rte autoload_rte" >{$fields_value[$input.name][$language.id_lang]|escape:'html':'UTF-8'}</textarea>
					{if $languages|count > 1}
					</div>
					<div class="col-lg-2">
						<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
							{$language.iso_code}
							<span class="caret"></span>
						</button>
						<ul class="dropdown-menu">
							{foreach from=$languages item=language}
								<li>
									<a href="javascript:hideOtherLanguage({$language.id_lang});" tabindex="-1">{$language.name}</a>
								</li>
							{/foreach}
						</ul>
					</div>
				</div>
			{/if}
		{/foreach}
{/if}
